/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.selector;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigMenuProvider;
import net.swedz.little_big_redstone.microchip.object.logic.selector.LogicSelectorConfigMenuProvider;
import net.swedz.little_big_redstone.microchip.object.logic.selector.LogicSelectorMode;
import net.swedz.tesseract.neoforge.api.range.IntRange;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public final class LogicSelectorConfig
extends LogicConfig<LogicSelectorConfig> {
    public static final MapCodec<LogicSelectorConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecHelper.forLowercaseEnum(LogicSelectorMode.class).optionalFieldOf("mode", (Object)LogicSelectorMode.COUNTER).forGetter(config -> config.mode), (App)Codec.intRange((int)2, (int)10).optionalFieldOf("outputs", (Object)2).forGetter(config -> config.outputs)).apply((Applicative)instance, LogicSelectorConfig::new));
    public static final StreamCodec<ByteBuf, LogicSelectorConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)CodecHelper.forLowercaseEnumStream(LogicSelectorMode.class), config -> config.mode, (StreamCodec)ByteBufCodecs.INT, config -> config.outputs, LogicSelectorConfig::new);
    public LogicSelectorMode mode;
    public int outputs;

    private LogicSelectorConfig(LogicSelectorMode mode, int outputs) {
        this.mode = mode;
        this.outputs = outputs;
    }

    public LogicSelectorConfig() {
        this(LogicSelectorMode.COUNTER, 2);
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicConfigTooltipMode(this.mode));
        lines.add((Component)LBR.text().logicConfigTooltipOutputs(this.outputs));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    public LogicConfigMenuProvider<LogicSelectorConfig> getMenuProvider() {
        return new LogicSelectorConfigMenuProvider(this);
    }

    @Override
    protected void internalLoadFrom(LogicSelectorConfig other) {
        this.mode = other.mode;
        this.outputs = other.outputs;
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(2, 10);
    }

    @Override
    public int inputs() {
        return this.mode == LogicSelectorMode.COUNTER ? 2 : this.outputs;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(2, 10);
    }

    @Override
    public int outputs() {
        return this.outputs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mode, this.outputs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicSelectorConfig)) return false;
        LogicSelectorConfig other = (LogicSelectorConfig)o;
        if (this.mode != other.mode) return false;
        if (this.outputs != other.outputs) return false;
        return true;
    }
}

