/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.io;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicComparisonMode;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigButtonReference;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigMenuBuilder;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigMenuProvider;
import net.swedz.little_big_redstone.microchip.object.logic.io.LogicIOConfig;

final class LogicIOConfigMenuProvider
extends LogicConfigMenuProvider<LogicIOConfig> {
    private LogicConfigButtonReference<LogicComparisonMode> comparisonButton;
    private LogicConfigButtonReference<Double> signalStrengthSlider;

    public LogicIOConfigMenuProvider(LogicIOConfig config) {
        super(config);
    }

    private void updateComparisonButton() {
        if (this.comparisonButton != null) {
            this.comparisonButton.setTooltip((Component)(this.comparisonButton.isActive() ? this.signalComparisonTooltip() : LBR.text().logicConfigButtonTooltipIoSignalComparisonOutput(((LogicIOConfig)this.config).signalStrength)));
        }
    }

    private void createMode(LogicConfigMenuBuilder builder, int width, int height) {
        builder.addCycleButton((Component)LBR.text().logicConfigButtonLabelMode(), (Component)LBR.text().logicConfigButtonTooltipIoMode(), 0, 0, width, 18, false, ((LogicIOConfig)this.config).input, List.of(Boolean.valueOf(true), Boolean.valueOf(false)), value -> LBRTooltips.INPUT_OUTPUT_PARSER.parse(value).plainCopy(), value -> {
            ((LogicIOConfig)this.config).input = value;
            int n = ((LogicIOConfig)this.config).signalStrength = ((LogicIOConfig)this.config).input ? 1 : 15;
            if (this.signalStrengthSlider != null) {
                this.signalStrengthSlider.setValue(Double.valueOf(((LogicIOConfig)this.config).signalStrength));
                this.signalStrengthSlider.setTooltip(this.tooltipSignalStrength());
            }
            if (this.comparisonButton != null) {
                this.comparisonButton.setActive(((LogicIOConfig)this.config).input);
            }
            this.updateComparisonButton();
        });
    }

    private void createDirection(LogicConfigMenuBuilder builder, int width, int height) {
        builder.addCycleButton((Component)LBR.text().logicConfigButtonLabelDirection(), (Component)LBR.text().logicConfigButtonTooltipIoDirection(), 0, 22, width, 18, false, ((LogicIOConfig)this.config).direction, Arrays.asList(Direction.values()), arg_0 -> LBRTooltips.DIRECTION_PARSER.parse(arg_0), value -> {
            ((LogicIOConfig)this.config).direction = value;
        });
    }

    private Component signalComparisonTooltip() {
        return switch (((LogicIOConfig)this.config).signalComparison) {
            default -> throw new MatchException(null, null);
            case LogicComparisonMode.LESS_THAN_OR_EQUAL_TO -> LBR.text().logicConfigButtonTooltipIoSignalComparisonModeLessThanOrEqualTo(((LogicIOConfig)this.config).signalStrength);
            case LogicComparisonMode.EQUAL_TO -> LBR.text().logicConfigButtonTooltipIoSignalComparisonModeEqualTo(((LogicIOConfig)this.config).signalStrength);
            case LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO -> LBR.text().logicConfigButtonTooltipIoSignalComparisonModeGreaterThanOrEqualTo(((LogicIOConfig)this.config).signalStrength);
        };
    }

    private void createComparison(LogicConfigMenuBuilder builder, int width, int height) {
        this.comparisonButton = builder.addCycleButton(this.signalComparisonTooltip(), 0, 44, LBR.id("textures/gui/slot_atlas.png"), ((LogicIOConfig)this.config).signalComparison, Arrays.asList(LogicComparisonMode.values()), value -> {
            ((LogicIOConfig)this.config).signalComparison = value;
            this.updateComparisonButton();
        }).setActive(((LogicIOConfig)this.config).input);
        this.updateComparisonButton();
    }

    private Component tooltipSignalStrength() {
        return ((LogicIOConfig)this.config).input ? LBR.text().logicConfigButtonTooltipIoSignalStrengthInput() : LBR.text().logicConfigButtonTooltipIoSignalStrengthOutput();
    }

    private void createSignalStrength(LogicConfigMenuBuilder builder, int width, int height) {
        this.signalStrengthSlider = builder.addSlider((Component)LBR.text().logicConfigButtonLabelIoSignalStrength(), (Component)Component.empty(), this.tooltipSignalStrength(), 22, 44, width - 18 - 4, 18, 1.0, 15.0, ((LogicIOConfig)this.config).signalStrength, 1.0, 0, value -> {
            ((LogicIOConfig)this.config).signalStrength = value.intValue();
            this.updateComparisonButton();
        });
    }

    @Override
    public void create(LogicConfigMenuBuilder builder, int width, int height) {
        this.createMode(builder, width, height);
        this.createDirection(builder, width, height);
        this.createComparison(builder, width, height);
        this.createSignalStrength(builder, width, height);
    }
}

