/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicFactory;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.debug.LogicDebugger;
import net.swedz.little_big_redstone.microchip.object.logic.gate.ANDGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.LogicGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.NANDGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.NORGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.NOTGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.ORGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.XORGate;
import net.swedz.little_big_redstone.microchip.object.logic.io.LogicIO;
import net.swedz.little_big_redstone.microchip.object.logic.latch.rs.RSNORLatch;
import net.swedz.little_big_redstone.microchip.object.logic.latch.tflipflop.TFlipFlop;
import net.swedz.little_big_redstone.microchip.object.logic.pulse.PulseThrottler;
import net.swedz.little_big_redstone.microchip.object.logic.randomizer.LogicRandomizer;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReader;
import net.swedz.little_big_redstone.microchip.object.logic.selector.LogicSelector;
import net.swedz.little_big_redstone.microchip.object.logic.sequencer.LogicSequencer;
import org.apache.commons.lang3.mutable.MutableInt;

public final class LogicTypes {
    private static final List<LogicType<?>> LOGICS = Lists.newArrayList();
    private static final Map<String, LogicType<?>> LOGICS_MAP = Maps.newHashMap();
    private static final MutableInt SYMBOL = new MutableInt();
    static final Codec<LogicComponent> CODEC = Codec.STRING.comapFlatMap(LogicTypes::getMaybe, LogicType::id).dispatch(LogicComponent::type, LogicType::codec);
    static final StreamCodec<ByteBuf, LogicComponent> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(LogicTypes::get, LogicType::id).dispatch(LogicComponent::type, LogicType::streamCodec);
    public static final LogicType<LogicDebugger> DEBUGGER = LogicTypes.register("debugger", "Debugger", LogicDebugger.CODEC, LogicDebugger.STREAM_CODEC, LogicDebugger::new);
    public static final LogicType<LogicIO> IO = LogicTypes.register("io", "I/O Port", LogicIO.CODEC, LogicIO.STREAM_CODEC, LogicIO::new);
    public static final LogicType<NOTGate> NOT = LogicTypes.registerGate("not", "NOT", NOTGate.CODEC, NOTGate.STREAM_CODEC, NOTGate::new);
    public static final LogicType<ANDGate> AND = LogicTypes.registerGate("and", "AND", ANDGate.CODEC, ANDGate.STREAM_CODEC, ANDGate::new);
    public static final LogicType<NANDGate> NAND = LogicTypes.registerGate("nand", "NAND", NANDGate.CODEC, NANDGate.STREAM_CODEC, NANDGate::new);
    public static final LogicType<ORGate> OR = LogicTypes.registerGate("or", "OR", ORGate.CODEC, ORGate.STREAM_CODEC, ORGate::new);
    public static final LogicType<NORGate> NOR = LogicTypes.registerGate("nor", "NOR", NORGate.CODEC, NORGate.STREAM_CODEC, NORGate::new);
    public static final LogicType<XORGate> XOR = LogicTypes.registerGate("xor", "XOR", XORGate.CODEC, XORGate.STREAM_CODEC, XORGate::new);
    public static final LogicType<LogicReader> READER = LogicTypes.register("reader", "Reader", LogicReader.CODEC, LogicReader.STREAM_CODEC, LogicReader::new);
    public static final LogicType<LogicSequencer> SEQUENCER = LogicTypes.register("sequencer", "Sequencer", LogicSequencer.CODEC, LogicSequencer.STREAM_CODEC, LogicSequencer::new);
    public static final LogicType<PulseThrottler> PULSE_THROTTLER = LogicTypes.register("pulse_throttler", "Pulse Throttler", PulseThrottler.CODEC, PulseThrottler.STREAM_CODEC, PulseThrottler::new);
    public static final LogicType<LogicSelector> SELECTOR = LogicTypes.register("selector", "Selector", LogicSelector.CODEC, LogicSelector.STREAM_CODEC, LogicSelector::new);
    public static final LogicType<LogicRandomizer> RANDOMIZER = LogicTypes.register("randomizer", "Randomizer", LogicRandomizer.CODEC, LogicRandomizer.STREAM_CODEC, LogicRandomizer::new);
    public static final LogicType<TFlipFlop> T_FLIP_FLOP = LogicTypes.register("t_flip_flop", "T Flip-Flop", TFlipFlop.CODEC, TFlipFlop.STREAM_CODEC, TFlipFlop::new);
    public static final LogicType<RSNORLatch> RS_NOR_LATCH = LogicTypes.register("rs_nor_latch", "RS NOR Latch", RSNORLatch.CODEC, RSNORLatch.STREAM_CODEC, RSNORLatch::new);

    public static List<LogicType<?>> values() {
        return Collections.unmodifiableList(LOGICS);
    }

    private static DataResult<LogicType<?>> getMaybe(String id) {
        LogicType<?> type = LOGICS_MAP.get(id);
        return type == null ? DataResult.error(() -> "No logic type exists for the id %s".formatted(id)) : DataResult.success(type);
    }

    public static LogicType<?> get(String id) {
        return (LogicType)LogicTypes.getMaybe(id).getOrThrow(IllegalArgumentException::new);
    }

    private static <T extends LogicComponent> LogicType<T> register(String id, String englishName, MapCodec<T> codec, StreamCodec<ByteBuf, T> streamCodec, LogicFactory defaultFactory) {
        LogicType<T> type = new LogicType<T>(id, englishName, (char)(SYMBOL.getAndIncrement() + 48), codec, streamCodec, defaultFactory);
        LOGICS.add(type);
        LOGICS_MAP.put(id, type);
        return type;
    }

    private static <T extends LogicGate> LogicType<T> registerGate(String id, String englishName, MapCodec<T> codec, StreamCodec<ByteBuf, T> streamCodec, LogicFactory defaultFactory) {
        return LogicTypes.register(id + "_gate", englishName + " Gate", codec, streamCodec, defaultFactory);
    }

    public static void init() {
    }
}

