/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.MicrochipObjectContainerType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.tesseract.neoforge.api.Bounds;

public record LogicEntry(int slot, int x, int y, LogicComponent component) implements MicrochipObject
{
    public static final Codec<LogicEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("slot").forGetter(LogicEntry::slot), (App)Codec.INT.fieldOf("x").forGetter(LogicEntry::x), (App)Codec.INT.fieldOf("y").forGetter(LogicEntry::y), (App)LogicComponent.CODEC.fieldOf("logic").forGetter(LogicEntry::component)).apply((Applicative)instance, LogicEntry::new));
    public static final StreamCodec<ByteBuf, LogicEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, LogicEntry::slot, (StreamCodec)ByteBufCodecs.VAR_INT, LogicEntry::x, (StreamCodec)ByteBufCodecs.VAR_INT, LogicEntry::y, LogicComponent.STREAM_CODEC, LogicEntry::component, LogicEntry::new);

    public LogicEntry {
        component = component.copy();
    }

    @Override
    public MicrochipObjectContainerType containerType() {
        return MicrochipObjectContainerType.LOGIC_COMPONENT;
    }

    @Override
    public ItemStack toStack() {
        return this.component.type().toStack(this.component);
    }

    @Override
    public Bounds toBounds() {
        return new Bounds(this.x, this.y, this.size().widthPixels(), this.size().heightPixels());
    }

    @Override
    public Optional<DyeColor> color() {
        return this.component.color();
    }

    @Override
    public boolean setColor(Optional<DyeColor> color) {
        Optional<DyeColor> original = this.component.color();
        this.component.setColor(color);
        return !original.equals(color);
    }

    public LogicGridSize size() {
        return this.component.size();
    }
}

