/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.MicrochipObjectContainer;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.little_big_redstone.microchip.object.logic.LogicSelectedPort;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTraversal;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.wire.Wire;

public final class LogicComponents
extends MicrochipObjectContainer<LogicEntry, LogicComponents> {
    public static final Codec<LogicComponents> CODEC = Codec.list(LogicEntry.CODEC).xmap(LogicComponents::new, MicrochipObjectContainer::values);
    public static final StreamCodec<ByteBuf, LogicComponents> STREAM_CODEC = LogicEntry.STREAM_CODEC.apply(ByteBufCodecs.list()).map(LogicComponents::new, MicrochipObjectContainer::values);
    private List<LogicEntry> traversalOrder = List.of();
    private boolean debug;

    private LogicComponents(Microchip microchip, List<LogicEntry> components) {
        super(microchip, components);
        for (LogicEntry entry : components) {
            if (entry.component().type() != LogicTypes.DEBUGGER) continue;
            this.debug = true;
            break;
        }
    }

    private LogicComponents(List<LogicEntry> components) {
        this((Microchip)null, components);
    }

    public LogicComponents(Microchip microchip) {
        this(microchip, Lists.newArrayList());
    }

    public List<LogicEntry> traversal() {
        return this.traversalOrder;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public LogicSelectedPort findPortAt(int x, int y, boolean input) {
        for (LogicEntry entry : this.values()) {
            LogicGridSize size = entry.size();
            int totalPorts = input ? entry.component().inputs() : entry.component().outputs();
            for (int index = 0; index < totalPorts; ++index) {
                if (!size.portBounds(entry.x(), entry.y(), input, index, totalPorts).contains(x, y)) continue;
                return new LogicSelectedPort(entry, index);
            }
        }
        return null;
    }

    public LogicEntry add(int x, int y, LogicComponent component) {
        if (this.microchip.canFit(component.size().toBounds(x, y))) {
            return this.addUnsafe(x, y, component);
        }
        return null;
    }

    public LogicEntry addUnsafe(int x, int y, LogicComponent component) {
        if (component.type() == LogicTypes.DEBUGGER) {
            if (this.debug) {
                return null;
            }
            this.debug = true;
        }
        int slot = this.pickAvailableSlot();
        LogicEntry entry = new LogicEntry(slot, x, y, component);
        this.objects.put(slot, entry);
        return entry;
    }

    public List<Wire> remove(int slot) {
        ArrayList wiresRemoved = Lists.newArrayList();
        LogicEntry original = (LogicEntry)this.objects.remove(slot);
        wiresRemoved.addAll(this.microchip.wires().removeAllOutputs(slot));
        wiresRemoved.addAll(this.microchip.wires().removeAllInputs(slot));
        if (original.component().type() == LogicTypes.DEBUGGER) {
            this.debug = false;
        }
        return Collections.unmodifiableList(wiresRemoved);
    }

    public List<Wire> remove(LogicEntry entry) {
        return this.remove(entry.slot());
    }

    public void rebuildTraversal() {
        this.traversalOrder = LogicTraversal.buildOrder(this.microchip);
    }

    public void updateValidity() {
        for (LogicEntry entry : this.objects.values()) {
            ((LogicConfig)entry.component().config()).recalculateValidity(this);
        }
    }

    @Override
    public LogicComponents with(Microchip microchip) {
        LogicComponents components = new LogicComponents(microchip);
        components.loadFrom(this);
        return components;
    }

    @Override
    public void loadFrom(LogicComponents other) {
        this.loadFrom(other, before -> new LogicEntry(before.slot(), before.x(), before.y(), before.component()));
    }

    public void loadFrom(LogicComponents other, Function<LogicEntry, LogicEntry> conversion) {
        HashMap copiedComponents = Maps.newHashMap();
        other.objects.forEach((? super K slot, ? super V entry) -> copiedComponents.put(slot, (LogicEntry)conversion.apply((LogicEntry)entry)));
        this.objects = copiedComponents;
        this.debug = other.debug;
    }

    @Override
    public void clear() {
        super.clear();
        this.traversalOrder = List.of();
        this.debug = false;
    }

    @Override
    public int hashCode() {
        return this.objects.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicComponents)) return false;
        LogicComponents other = (LogicComponents)o;
        if (this.hashCode() != other.hashCode()) return false;
        return true;
    }
}

