/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.awareness.types;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessContext;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessType;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.awareness.MicrochipAwareness;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReader;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderConfig;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderMode;

public final class AnalogSignalAwareness
extends MicrochipAwareness<AnalogSignalAwareness> {
    private boolean initialized;
    private boolean[] sides = new boolean[6];
    private int[] signals = new int[6];

    public int getSignal(Direction direction) {
        return this.signals[direction.ordinal()];
    }

    @Override
    public AwarenessType<AnalogSignalAwareness> type() {
        return AwarenessTypes.ANALOG_SIGNAL;
    }

    @Override
    public void load(Microchip microchip) {
        boolean[] sides = new boolean[6];
        for (LogicEntry entry : microchip.components()) {
            LogicComponent logicComponent = entry.component();
            if (!(logicComponent instanceof LogicReader)) continue;
            LogicReader reader = (LogicReader)logicComponent;
            int direction = ((LogicReaderConfig)reader.config()).direction.ordinal();
            if (sides[direction] || ((LogicReaderConfig)reader.config()).mode != LogicReaderMode.COMPARATOR) continue;
            sides[direction] = true;
        }
        this.sides = sides;
    }

    @Override
    public void neighborChanged(AwarenessContext context, Block neighborBlock, BlockPos neighborPos, Direction neighborDirection, boolean movedByPiston) {
        BlockState state;
        Level level = context.level();
        int neighborDirectionIndex = neighborDirection.ordinal();
        if (this.sides[neighborDirectionIndex] && (state = level.getBlockState(neighborPos)).hasAnalogOutputSignal()) {
            int signal;
            this.signals[neighborDirectionIndex] = signal = state.getAnalogOutputSignal(level, neighborPos);
            return;
        }
        this.signals[neighborDirectionIndex] = 0;
    }

    @Override
    public void preTick(AwarenessContext context) {
        Level level = context.level();
        BlockPos pos = context.pos();
        if (!this.initialized) {
            int[] signals = new int[6];
            for (int directionIndex = 0; directionIndex < this.sides.length; ++directionIndex) {
                int signal;
                Direction direction;
                BlockPos neighborPos;
                BlockState state;
                if (!this.sides[directionIndex] || !(state = level.getBlockState(neighborPos = pos.relative(direction = Direction.values()[directionIndex]))).hasAnalogOutputSignal()) continue;
                signals[directionIndex] = signal = state.getAnalogOutputSignal(level, neighborPos);
            }
            this.signals = signals;
            this.initialized = true;
        }
    }

    @Override
    public void postTick(AwarenessContext context, boolean microchipDirty, boolean contextDirty) {
    }
}

