/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.truthtable;

import com.google.common.collect.Maps;
import guideme.compiler.IndexingContext;
import guideme.compiler.IndexingSink;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytParagraph;
import guideme.document.block.table.LytTable;
import guideme.document.block.table.LytTableCell;
import guideme.document.block.table.LytTableRow;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowText;
import guideme.extensions.ExtensionCollection;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.model.MdAstAnyContent;
import guideme.libs.unist.UnistNode;
import java.util.Map;
import java.util.Set;
import net.swedz.little_big_redstone.guide.tags.truthtable.element.TruthTableElementTagCompiler;

public final class TruthTableTagCompiler
extends BlockTagCompiler {
    private final Map<String, TruthTableElementTagCompiler> elementTagCompilers = Maps.newHashMap();
    private static final char[] INPUT_CHARS = "ABCD".toCharArray();
    private static final char[] OUTPUT_CHARS = "QXYZ".toCharArray();

    public Set<String> getTagNames() {
        return Set.of("TruthTable");
    }

    private static void header(LytTableRow row, String label) {
        LytTableCell header = row.appendCell();
        LytParagraph text = new LytParagraph();
        text.append((LytFlowContent)LytFlowText.of((String)label));
        header.append((LytBlock)text);
    }

    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        int inputs = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"inputs", (int)1);
        int outputs = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"outputs", (int)1);
        LytTable table = new LytTable();
        LytTableRow header = table.appendRow();
        TruthTableTagCompiler.header(header, "Input");
        TruthTableTagCompiler.header(header, "Output");
        LytTableRow contentRow = table.appendRow();
        LytTableCell inputColumn = contentRow.appendCell();
        LytTable inputTable = new LytTable();
        LytTableCell outputColumn = contentRow.appendCell();
        LytTable outputTable = new LytTable();
        if (inputs > 1 || outputs > 1) {
            LytTableRow inputTableHeader = inputTable.appendRow();
            for (int i = 0; i < inputs; ++i) {
                TruthTableTagCompiler.header(inputTableHeader, String.valueOf(INPUT_CHARS[i]));
            }
            LytTableRow outputTableHeader = outputTable.appendRow();
            for (int i = 0; i < outputs; ++i) {
                TruthTableTagCompiler.header(outputTableHeader, String.valueOf(OUTPUT_CHARS[i]));
            }
        }
        for (MdAstAnyContent child : el.children()) {
            if (!(child instanceof MdxJsxElementFields)) continue;
            MdxJsxElementFields childEl = (MdxJsxElementFields)child;
            String childTagName = childEl.name();
            TruthTableElementTagCompiler childCompiler = this.elementTagCompilers.get(childTagName);
            if (childCompiler == null) {
                parent.appendError(compiler, "Unknown truth table element", (UnistNode)child);
                continue;
            }
            childCompiler.compile(inputTable, outputTable, compiler, (LytErrorSink)parent, childEl);
        }
        inputColumn.append((LytBlock)inputTable);
        outputColumn.append((LytBlock)outputTable);
        parent.append((LytBlock)table);
    }

    public void onExtensionsBuilt(ExtensionCollection extensions) {
        for (TruthTableElementTagCompiler sceneElementTag : extensions.get(TruthTableElementTagCompiler.EXTENSION_POINT)) {
            for (String tagName : sceneElementTag.getTagNames()) {
                this.elementTagCompilers.put(tagName, sceneElementTag);
            }
        }
    }

    public void index(IndexingContext indexer, MdxJsxElementFields el, IndexingSink sink) {
    }
}

