/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicconfig.button;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.swedz.little_big_redstone.gui.logicconfig.button.LogicConfigButtonHelper;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public class LogicConfigButton
extends AbstractButton
implements LogicConfigButtonHelper {
    private final int color;
    private final OnPress onPress;

    public LogicConfigButton(int x, int y, int width, int height, int color, Component message, OnPress onPress) {
        super(x, y, width, height, message);
        this.color = color;
        this.onPress = onPress;
    }

    public void onPress() {
        this.onPress.onPress(this);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected void renderWidget(GuiGraphics internal, int mouseX, int mouseY, float partialTick) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(internal);
        this.renderBackground(graphics, partialTick, this.getX(), this.getY(), this.width, this.height, this.color, this.active && this.isHoveredOrFocused());
        this.renderBorder(graphics, this.getX(), this.getY(), this.width, this.height, this.color);
        graphics.setColor(this.color);
        graphics.setStringDropShadow(false);
        graphics.drawCenteredString(this.getMessage(), (float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f);
        graphics.resetColor();
    }

    public static interface OnPress {
        public void onPress(LogicConfigButton var1);
    }
}

