/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.model.microchip;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlock;
import net.swedz.little_big_redstone.client.model.microchip.MicrochipModelData;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.Vector3f;

public final class MicrochipBakedModel
implements IDynamicBakedModel {
    private final ItemTransforms transforms;
    private final boolean useAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final TextureAtlasSprite particle;
    private final Map<Direction, TextureAtlasSprite> baseTextures;
    private final Map<Direction, TextureAtlasSprite> signalOnOverlayTextures;
    private final Map<Direction, TextureAtlasSprite> signalOffOverlayTextures;

    MicrochipBakedModel(ItemTransforms transforms, boolean useAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particle, Map<Direction, TextureAtlasSprite> baseTextures, Map<Direction, TextureAtlasSprite> signalOnOverlayTextures, Map<Direction, TextureAtlasSprite> signalOffOverlayTextures) {
        this.transforms = transforms;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particle = particle;
        this.baseTextures = baseTextures;
        this.signalOnOverlayTextures = signalOnOverlayTextures;
        this.signalOffOverlayTextures = signalOffOverlayTextures;
    }

    private static MicrochipModelData getModelData(ModelData modelData) {
        MicrochipModelData data = (MicrochipModelData)modelData.get(MicrochipModelData.KEY);
        return data != null ? data : MicrochipModelData.DEFAULT;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction cullDirection, RandomSource random, ModelData modelData, RenderType renderType) {
        MicrochipModelData data = MicrochipBakedModel.getModelData(modelData);
        ArrayList quads = Lists.newArrayList();
        quads.addAll(new ElementBuilder().allFaces().getQuads(this.baseTextures::get));
        if (state != null) {
            quads.addAll(new ElementBuilder().allFaces(data::side).getQuads(direction -> ((Boolean)state.getValue((Property)MicrochipBlock.getDirectionalState(direction)) != false ? this.signalOnOverlayTextures : this.signalOffOverlayTextures).get(direction)));
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particle;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.CUTOUT});
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        super.applyTransform(transformType, poseStack, applyLeftHandTransform);
        this.transforms.getTransform(transformType).apply(applyLeftHandTransform, poseStack);
        return this;
    }

    private static final class ElementBuilder {
        private final Map<Direction, BlockElementFace> faces = Maps.newHashMap();

        private ElementBuilder() {
        }

        public ElementBuilder face(Direction direction) {
            this.faces.put(direction, new BlockElementFace(null, -1, null, new BlockFaceUV(null, 0), null, new MutableObject()));
            return this;
        }

        public ElementBuilder allFaces(Predicate<Direction> filter) {
            for (Direction direction : Direction.values()) {
                if (filter != null && !filter.test(direction)) continue;
                this.face(direction);
            }
            return this;
        }

        public ElementBuilder allFaces() {
            return this.allFaces(null);
        }

        public List<BakedQuad> getQuads(Function<Direction, TextureAtlasSprite> spriteGetter) {
            ArrayList quads = Lists.newArrayList();
            BlockElement element = new BlockElement(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), this.faces, null, true);
            for (Direction direction : this.faces.keySet()) {
                quads.add(BlockModel.bakeFace((BlockElement)element, (BlockElementFace)this.faces.get(direction), (TextureAtlasSprite)spriteGetter.apply(direction), (Direction)direction, (ModelState)BlockModelRotation.X0_Y0));
            }
            return quads;
        }
    }
}

