/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.model.logic;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.client.model.logic.LogicBakedModel;
import net.swedz.little_big_redstone.client.model.logic.LogicModelColorSet;
import net.swedz.little_big_redstone.client.model.logic.LogicUnbakedModel;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public final class LogicBakingModelData {
    private static final UnboundedMapCodec<String, ResourceLocation> TEXTURE_MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.CODEC);
    public static final Codec<LogicBakingModelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)CodecHelper.forLowercaseEnum(DyeColor.class), LogicModelColorSet.CODEC).fieldOf("color_palette").forGetter(d -> d.colorPalette), (App)TEXTURE_MAP_CODEC.fieldOf("item_textures").forGetter(d -> d.itemTextures), (App)TEXTURE_MAP_CODEC.fieldOf("board_textures").forGetter(d -> d.boardTextures)).apply((Applicative)instance, LogicBakingModelData::new));
    private final Map<DyeColor, LogicModelColorSet> colorPalette;
    private final Map<String, ResourceLocation> itemTextures;
    private final Map<String, ResourceLocation> boardTextures;

    public static LogicBakingModelData get(LogicComponent<?, ?> component) {
        return ((LogicBakedModel)Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)LBR.id(component.type().id())))).getData();
    }

    private LogicBakingModelData(Map<DyeColor, LogicModelColorSet> colorPalette, Map<String, ResourceLocation> itemTextures, Map<String, ResourceLocation> boardTextures) {
        this.colorPalette = Collections.unmodifiableMap(colorPalette);
        this.itemTextures = Collections.unmodifiableMap(itemTextures);
        this.boardTextures = Collections.unmodifiableMap(boardTextures);
    }

    public LogicModelColorSet getColorSet(DyeColor color) {
        return this.colorPalette.getOrDefault(color, LogicModelColorSet.DEFAULT);
    }

    public LogicModelColorSet getColorSet(LogicComponent<?, ?> component, DyeColor fallback) {
        return this.getColorSet(component.color().orElse(fallback));
    }

    public ResourceLocation getItemTexture(String texture) {
        return this.itemTextures.getOrDefault(texture, ResourceLocation.withDefaultNamespace((String)"missingno"));
    }

    public ResourceLocation getItemTextureLocation(String texture) {
        return this.getItemTexture(texture).withPath(arg_0 -> LogicBakingModelData.lambda$getItemTextureLocation$4("textures/%s.png", arg_0));
    }

    public ResourceLocation getBoardTexture(String texture) {
        return this.boardTextures.getOrDefault(texture, ResourceLocation.withDefaultNamespace((String)"missingno"));
    }

    public ResourceLocation getBoardTextureLocation(String texture) {
        return this.getBoardTexture(texture).withPath(arg_0 -> LogicBakingModelData.lambda$getBoardTextureLocation$5("textures/%s.png", arg_0));
    }

    public static <T extends ModelBuilder<T>> Builder<T> builder(T parent, ExistingFileHelper existingFileHelper) {
        return new Builder<T>(parent, existingFileHelper);
    }

    private static /* synthetic */ String lambda$getBoardTextureLocation$5(String rec$, Object xva$0) {
        return "textures/%s.png".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$getItemTextureLocation$4(String rec$, Object xva$0) {
        return "textures/%s.png".formatted(xva$0);
    }

    public static final class Builder<T extends ModelBuilder<T>>
    extends CustomLoaderBuilder<T> {
        private final Map<DyeColor, LogicModelColorSet> colorPalette = Maps.newHashMap();
        private final Map<String, ResourceLocation> itemTextures = Maps.newHashMap();
        private final Map<String, ResourceLocation> boardTextures = Maps.newHashMap();

        private Builder(T parent, ExistingFileHelper existingFileHelper) {
            super(LogicUnbakedModel.ID, parent, existingFileHelper, false);
        }

        public Builder<T> foregroundColor(DyeColor dyeColor, int color) {
            Assert.noneNull((Object[])new Object[]{dyeColor});
            this.colorPalette.compute(dyeColor, (__, colorSet) -> {
                if (colorSet == null) {
                    colorSet = LogicModelColorSet.DEFAULT;
                }
                return new LogicModelColorSet(color, colorSet.background());
            });
            return this;
        }

        public Builder<T> backgroundColor(DyeColor dyeColor, int color) {
            Assert.noneNull((Object[])new Object[]{dyeColor});
            this.colorPalette.compute(dyeColor, (__, colorSet) -> {
                if (colorSet == null) {
                    colorSet = LogicModelColorSet.DEFAULT;
                }
                return new LogicModelColorSet(colorSet.foreground(), color);
            });
            return this;
        }

        public Builder<T> itemTexture(String key, ResourceLocation texture) {
            Assert.notNull((Object)key);
            Assert.notNull((Object)texture);
            Assert.that((boolean)this.existingFileHelper.exists(texture, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE), (String)"Texture %s does not exist".formatted(texture));
            this.itemTextures.put(key, texture);
            return this;
        }

        public Builder<T> boardTexture(String key, ResourceLocation texture) {
            Assert.notNull((Object)key);
            Assert.notNull((Object)texture);
            Assert.that((boolean)this.existingFileHelper.exists(texture, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE), (String)"Texture %s does not exist".formatted(texture));
            this.boardTextures.put(key, texture);
            return this;
        }

        public LogicBakingModelData build() {
            return new LogicBakingModelData(this.colorPalette, this.itemTextures, this.boardTextures);
        }

        public JsonObject toJson(JsonObject json) {
            json = super.toJson(json);
            JsonElement parsed = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.build()).getOrThrow(JsonParseException::new);
            for (Map.Entry entry : parsed.getAsJsonObject().entrySet()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return json;
        }
    }
}

