/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.block.microchip;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.item.DyeColoredItem;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessContext;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.awareness.types.RedstoneAwareness;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.tesseract.neoforge.api.TickableBlock;

public final class MicrochipBlock
extends Block
implements TickableBlock,
DyeColoredItem {
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    private final DyeColor color;

    public static BooleanProperty getDirectionalState(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    public MicrochipBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties.isRedstoneConductor(Blocks::never));
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public DyeColor color() {
        return this.color;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MicrochipBlockEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MicrochipBlockEntity) {
                MicrochipBlockEntity blockEntity2 = (MicrochipBlockEntity)blockEntity;
                blockEntity2.openMenu(player);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof MicrochipBlockEntity)) {
            return 0;
        }
        MicrochipBlockEntity blockEntity2 = (MicrochipBlockEntity)blockEntity;
        RedstoneAwareness redstone = blockEntity2.microchip().awarenesses().get(AwarenessTypes.REDSTONE);
        return redstone != null ? redstone.outputRedstoneSignal(state, direction) : 0;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (level.isClientSide() || !((blockEntity = level.getBlockEntity(pos)) instanceof MicrochipBlockEntity)) {
            return;
        }
        MicrochipBlockEntity blockEntity2 = (MicrochipBlockEntity)blockEntity;
        BlockPos delta = neighborPos.subtract((Vec3i)pos);
        Direction neighborDirection = Direction.fromDelta((int)delta.getX(), (int)delta.getY(), (int)delta.getZ());
        if (neighborDirection != null) {
            blockEntity2.microchip().awarenesses().neighborChanged(new AwarenessContext(blockEntity2), neighborBlock, neighborPos, neighborDirection, movedByPiston);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        Object object;
        if (!state.is(newState.getBlock()) && (object = level.getBlockEntity(pos)) instanceof MicrochipBlockEntity) {
            MicrochipBlockEntity blockEntity = (MicrochipBlockEntity)((Object)object);
            for (MicrochipObject entry : blockEntity.microchip().objects()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)entry.toStack());
            }
            ItemStack redstoneBits = new ItemStack(LBRItems.REDSTONE_BIT, blockEntity.microchip().wires().values().size());
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)redstoneBits);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

