/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRClientShaders;
import net.swedz.little_big_redstone.client.shader.LogicItemTextureStateShard;
import net.swedz.tesseract.neoforge.helper.CubeOverlayRenderHelper;

@EventBusSubscriber(modid="little_big_redstone", value={Dist.CLIENT})
public final class LBRClientRenderTypes {
    private static final Function<Direction, RenderType> MICROCHIP_OVERLAY = Util.memoize(direction -> {
        String directionName = direction.toString().toLowerCase(Locale.ROOT);
        return CubeOverlayRenderHelper.createRenderType((String)"microchip_side_overlay_%s".formatted(directionName), (ResourceLocation)LBR.id("textures/block/microchip/overlay_%s.png".formatted(directionName)));
    });
    private static final RenderType LOGIC_SCANLINE = RenderType.create((String)"logic_item_scanline", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(LBRClientShaders.LOGIC_ITEM_SCANLINE).setTextureState((RenderStateShard.EmptyTextureStateShard)new LogicItemTextureStateShard(InventoryMenu.BLOCK_ATLAS, LBR.id("textures/logic/scanline.png"), false, false)).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setCullState(RenderType.NO_CULL).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true));

    public static RenderType microchipOverlay(Direction direction) {
        return MICROCHIP_OVERLAY.apply(direction);
    }

    public static RenderType logicScanline() {
        return LOGIC_SCANLINE;
    }

    @SubscribeEvent
    private static void onRegisterRenderBuffers(RegisterRenderBuffersEvent event) {
        for (Direction direction : Direction.values()) {
            event.registerRenderBuffer(LBRClientRenderTypes.microchipOverlay(direction));
        }
    }
}

