/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.datagen;

import dev.satherov.epitaphs.core.annotations.NothingNull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;

@NothingNull
public class EPDataProvider
implements DataProvider {
    private final List<DataProvider> subProviders = new ArrayList<DataProvider>();

    public void addSubProvider(boolean include, DataProvider provider) {
        if (include) {
            this.subProviders.add(provider);
        }
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        for (DataProvider provider : this.subProviders) {
            list.add(provider.run(cachedOutput));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Epitaphs Data Provider";
    }
}

