/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.core;

import com.mojang.brigadier.CommandDispatcher;
import dev.satherov.epitaphs.Epitaphs;
import dev.satherov.epitaphs.EpitaphsConfig;
import dev.satherov.epitaphs.client.lang.EPLanguage;
import dev.satherov.epitaphs.common.block.GraveBlock;
import dev.satherov.epitaphs.common.command.EPCommands;
import dev.satherov.epitaphs.common.component.EPGraveDataAttachment;
import dev.satherov.epitaphs.common.component.EPLocationAttachment;
import dev.satherov.epitaphs.common.component.EPSoulboundAttachment;
import dev.satherov.epitaphs.common.data.BackupHandler;
import dev.satherov.epitaphs.common.data.EBackupType;
import dev.satherov.epitaphs.common.data.SoulboundHandler;
import dev.satherov.epitaphs.common.tile.GraveBlockEntity;
import dev.satherov.epitaphs.compat.CompatHandler;
import dev.satherov.epitaphs.compat.CurioHandler;
import dev.satherov.epitaphs.core.EPRegistry;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import oshi.util.tuples.Pair;

public class EPEventManager {
    private static Instant LAST_BACKUP = Instant.MIN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ServerLevel level = player.serverLevel();
        MinecraftServer server = level.getServer();
        if (((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get()) {
            return;
        }
        List SaveState = (List)Util.make(new ArrayList(), list -> {
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                list.add(inv.getItem(i).copy());
            }
            Pair pair = CompatHandler.run("curios", () -> CurioHandler.getCurio(player), new Pair(new ArrayList(), new ArrayList()));
            list.addAll((Collection)pair.getA());
            list.addAll((Collection)pair.getB());
        });
        try {
            String timestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").withZone(ZoneOffset.UTC).format(Instant.now());
            SoulboundHandler.handleSoulbound(player);
            if (player.getInventory().isEmpty() && CompatHandler.run("curios", () -> CurioHandler.isEmpty(player), true).booleanValue()) {
                return;
            }
            if (BackupHandler.save(player, timestamp, EBackupType.DEATH) != 0) {
                return;
            }
            List<ItemStack> backupContents = BackupHandler.getContents(level.getServer(), player.getStringUUID(), timestamp);
            boolean hasItems = false;
            for (ItemStack s : backupContents) {
                if (s.isEmpty()) continue;
                hasItems = true;
                break;
            }
            if (!hasItems) {
                return;
            }
            Optional<BlockPos> safeSpot = GraveBlock.findSafeSpot(level, player.blockPosition());
            if (safeSpot.isEmpty()) {
                player.displayClientMessage((Component)EPLanguage.MESSAGE_GRAVE_FAILED.translateFormatted(ChatFormatting.RED), false);
                return;
            }
            BlockPos pos = safeSpot.get();
            BlockState below = level.getBlockState(pos.below());
            if (below.is(BlockTags.REPLACEABLE)) {
                if (level.getBlockState(pos.below(2)).is(BlockTags.REPLACEABLE)) {
                    level.setBlockAndUpdate(pos.below(), Blocks.DIRT.defaultBlockState());
                } else {
                    pos = pos.below();
                }
            }
            BlockPos gravePos = pos.immutable();
            level.setBlockAndUpdate(gravePos, ((GraveBlock)((Object)EPRegistry.GRAVE.get())).defaultBlockState());
            GraveBlockEntity grave = new GraveBlockEntity(gravePos, level.getBlockState(gravePos));
            grave.setData(EPRegistry.GRAVE_DATA, ((EPGraveDataAttachment)grave.getData(EPRegistry.GRAVE_DATA)).create(player, timestamp));
            level.setBlockEntity((BlockEntity)grave);
            server.sendSystemMessage((Component)Component.literal((String)("Created Grave for " + player.getGameProfile().getName() + " at " + gravePos.getX() + ", " + gravePos.getY() + ", " + gravePos.getZ())));
            player.displayClientMessage((Component)Component.empty().append((Component)EPLanguage.MESSAGE_GRAVE_SUCCESS.translate()).append((Component)Component.literal((String)" ")).append((Component)ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{gravePos.getX(), gravePos.getY(), gravePos.getZ()})).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in %s run tp @s %s %s %s".formatted(level.dimension().location(), gravePos.getX(), gravePos.getY(), gravePos.getZ())))).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.GRAY), false);
            player.setData(EPRegistry.LOCATION_DATA, (Object)((EPLocationAttachment)player.getData(EPRegistry.LOCATION_DATA)).addGraveLocation(player, timestamp, gravePos));
        }
        catch (Exception e) {
            Epitaphs.LOGGER.error("Failed to create grave", (Throwable)e);
            player.displayClientMessage((Component)EPLanguage.MESSAGE_GRAVE_FAILED.translateFormatted(ChatFormatting.RED), false);
            for (ItemStack stack : SaveState) {
                if (stack.isEmpty()) continue;
                player.drop(stack, false);
            }
        }
        finally {
            SaveState.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        SoulboundHandler.restoreSoulbound(player2);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onLootEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (event.getDrops().isEmpty()) {
            return;
        }
        ServerLevel level = player.serverLevel();
        if (((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get()) {
            return;
        }
        MinecraftServer server = level.getServer();
        Optional<GlobalPos> position = ((EPLocationAttachment)player.getData(EPRegistry.LOCATION_DATA)).findLatestGraveLocation(level);
        if (position.isEmpty() || !position.get().dimension().equals(level.dimension())) {
            return;
        }
        BlockPos gravePos = position.get().pos().immutable();
        BlockEntity blockEntity = level.getBlockEntity(gravePos);
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return;
        }
        GraveBlockEntity grave = (GraveBlockEntity)blockEntity;
        EPGraveDataAttachment graveData = (EPGraveDataAttachment)grave.getData(EPRegistry.GRAVE_DATA);
        List<ItemStack> saved = BackupHandler.getContents(server, graveData.getOwner(), graveData.getTimestamp());
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(event.getDrops().stream().map(ItemEntity::getItem).toList());
        drops.removeAll(saved);
        if (drops.isEmpty()) {
            return;
        }
        graveData.saveAdditional(drops);
        grave.setData(EPRegistry.GRAVE_DATA, graveData);
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ServerLevel level = player.serverLevel();
        if (((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get()) {
            return;
        }
        EPSoulboundAttachment attachment = (EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA);
        int xp = SoulboundHandler.handleXpSoulbound(player);
        if (xp > 0) {
            int experience = player.totalExperience;
            attachment.setExperience(experience / 4 * xp);
            event.setDroppedExperience((int)Math.floor((double)event.getDroppedExperience() - (double)event.getDroppedExperience() / 4.0 * (double)xp));
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(pos -> {
            BlockState state = event.getLevel().getBlockState(pos);
            return state.is((Block)EPRegistry.GRAVE.get());
        });
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        EPCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockEntity blockEntity = level2.getBlockEntity(event.getPos());
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return;
        }
        GraveBlockEntity grave = (GraveBlockEntity)blockEntity;
        if (event.isCanceled()) {
            event.setCanceled(false);
            Epitaphs.LOGGER.warn("Bypassing right-click event cancel");
        }
        MinecraftServer server = level2.getServer();
        EPGraveDataAttachment data = (EPGraveDataAttachment)grave.getData(EPRegistry.GRAVE_DATA);
        String uuid = data.getOwner();
        String timestamp = data.getTimestamp();
        if (!player2.getStringUUID().equals(uuid) && !player2.hasPermissions(4)) {
            ServerPlayer owner = server.getPlayerList().getPlayer(UUID.fromString(uuid));
            String user = owner == null ? "Unknown" : owner.getName().getString();
            player2.displayClientMessage((Component)EPLanguage.MESSAGE_NO_ACCESS.translate(user).withStyle(ChatFormatting.RED), true);
            return;
        }
        if (BackupHandler.restore(player2, uuid, timestamp, false) != 0) {
            player2.displayClientMessage((Component)EPLanguage.MESSAGE_GRAVE_ERROR.translateFormatted(ChatFormatting.RED), true);
            return;
        }
        for (ItemStack stack : data.getAdditional()) {
            if (stack.isEmpty() || player2.getInventory().add(stack)) continue;
            player2.drop(stack, false);
        }
        player2.inventoryMenu.broadcastChanges();
        player2.connection.send((Packet)new ClientboundContainerSetContentPacket(player2.inventoryMenu.containerId, player2.inventoryMenu.incrementStateId(), player2.inventoryMenu.getItems(), player2.inventoryMenu.getCarried()));
        level2.playSound(null, player2.getX(), player2.getY(), player2.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.4f, ((player2.getRandom().nextFloat() - player2.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        player2.setData(EPRegistry.LOCATION_DATA, (Object)((EPLocationAttachment)player2.getData(EPRegistry.LOCATION_DATA)).removeGraveLocation(player2, timestamp, grave.getBlockPos()));
        level2.removeBlockEntity(event.getPos());
        level2.removeBlock(event.getPos(), false);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    @SubscribeEvent
    private static void scheduleBackup(ServerTickEvent.Post event) {
        Duration interval;
        MinecraftServer server = event.getServer();
        Instant now = Instant.now();
        if (now.isAfter(LAST_BACKUP.plus(interval = Duration.ofMinutes(EpitaphsConfig.getBackupInterval())))) {
            Epitaphs.LOGGER.info("Running player backup task");
            BackupHandler.saveAll(server);
            LAST_BACKUP = now;
        }
    }
}

