/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.data;

import dev.satherov.epitaphs.common.component.EPSoulboundAttachment;
import dev.satherov.epitaphs.compat.CompatHandler;
import dev.satherov.epitaphs.compat.CurioHandler;
import dev.satherov.epitaphs.core.EPRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import oshi.util.tuples.Pair;

public class SoulboundHandler {
    public static void handleSoulbound(ServerPlayer player) {
        EPSoulboundAttachment attachment = (EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA);
        NonNullList<ItemStack> soulboundItems = SoulboundHandler.extractSoulboundItems((List<ItemStack>)player.getInventory().items);
        NonNullList<ItemStack> soulboundArmor = SoulboundHandler.extractSoulboundItems((List<ItemStack>)player.getInventory().armor);
        NonNullList<ItemStack> soulboundOffhand = SoulboundHandler.extractSoulboundItems((List<ItemStack>)player.getInventory().offhand);
        Pair pair = CompatHandler.run("curios", () -> CurioHandler.getCurio(player), new Pair(new ArrayList(), new ArrayList()));
        NonNullList<ItemStack> curio = SoulboundHandler.extractSoulboundItems((List)pair.getA());
        NonNullList<ItemStack> cosmetics = SoulboundHandler.extractSoulboundItems((List)pair.getB());
        attachment.setItems(player, soulboundItems);
        attachment.setArmor(player, soulboundArmor);
        attachment.setOffhand(player, soulboundOffhand);
        attachment.setCurio(player, (List<ItemStack>)curio, (List<ItemStack>)cosmetics);
        curio.forEach(stack -> CompatHandler.run("curios", () -> CurioHandler.removeCurio(player, stack, false)));
        cosmetics.forEach(stack -> CompatHandler.run("curios", () -> CurioHandler.removeCurio(player, stack, true)));
        player.setData(EPRegistry.SOULBOUND_DATA, (Object)attachment);
    }

    public static void restoreSoulbound(ServerPlayer player) {
        EPSoulboundAttachment attachment = (EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA);
        SoulboundHandler.restoreItemsToSlots(player, (NonNullList<ItemStack>)player.getInventory().items, attachment.getItems());
        SoulboundHandler.restoreItemsToSlots(player, (NonNullList<ItemStack>)player.getInventory().armor, attachment.getArmor());
        SoulboundHandler.restoreItemsToSlots(player, (NonNullList<ItemStack>)player.getInventory().offhand, attachment.getOffhand());
        CompatHandler.run("curios", () -> CurioHandler.setCurio(player, attachment.getCurio(), attachment.getCosmetics()));
        int experience = attachment.getExperience();
        if (experience > 0) {
            player.giveExperiencePoints(experience);
        }
        ((EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA)).clear();
    }

    public static int handleXpSoulbound(ServerPlayer player) {
        EPSoulboundAttachment attachment = (EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA);
        NonNullList<ItemStack> armor = attachment.getArmor();
        int xpSoulboundCount = 0;
        for (ItemStack stack : armor) {
            if (stack.isEmpty() || !SoulboundHandler.hasXpSoulbound(stack)) continue;
            ++xpSoulboundCount;
        }
        return xpSoulboundCount;
    }

    private static NonNullList<ItemStack> extractSoulboundItems(List<ItemStack> originalList) {
        NonNullList soulboundItems = NonNullList.withSize((int)originalList.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < originalList.size(); ++i) {
            ItemStack stack = originalList.get(i);
            if (!SoulboundHandler.hasSoulbound(stack)) continue;
            soulboundItems.set(i, (Object)stack.copy());
            originalList.set(i, ItemStack.EMPTY);
        }
        return soulboundItems;
    }

    private static void restoreItemsToSlots(ServerPlayer player, NonNullList<ItemStack> targetList, NonNullList<ItemStack> soulboundList) {
        for (int i = 0; i < Math.min(targetList.size(), soulboundList.size()); ++i) {
            ItemStack stack = (ItemStack)soulboundList.get(i);
            if (stack.isEmpty()) continue;
            if (((ItemStack)targetList.get(i)).isEmpty()) {
                targetList.set(i, (Object)stack);
                continue;
            }
            if (player.getInventory().add(stack)) continue;
            player.drop(stack, false);
        }
    }

    private static boolean hasSoulbound(ItemStack stack) {
        return EnchantmentHelper.has((ItemStack)stack, EPRegistry.SOULBOUND.get()) || EnchantmentHelper.has((ItemStack)stack, EPRegistry.EXPERIENCE_SOULBOUND.get());
    }

    private static boolean hasXpSoulbound(ItemStack stack) {
        return EnchantmentHelper.has((ItemStack)stack, EPRegistry.EXPERIENCE_SOULBOUND.get());
    }
}

