/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.component;

import dev.satherov.epitaphs.Epitaphs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class EPSoulboundAttachment
implements INBTSerializable<CompoundTag> {
    NonNullList<ItemStack> items = NonNullList.create();
    NonNullList<ItemStack> armor = NonNullList.create();
    NonNullList<ItemStack> offhand = NonNullList.create();
    List<ItemStack> curio = new ArrayList<ItemStack>();
    List<ItemStack> cosmetics = new ArrayList<ItemStack>();
    int experience = 0;

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public NonNullList<ItemStack> getArmor() {
        return this.armor;
    }

    public NonNullList<ItemStack> getOffhand() {
        return this.offhand;
    }

    public List<ItemStack> getCurio() {
        return this.curio;
    }

    public List<ItemStack> getCosmetics() {
        return this.cosmetics;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setItems(ServerPlayer player, NonNullList<ItemStack> items) {
        if (this.items.isEmpty() || this.items.size() != items.size()) {
            this.items = items;
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            ItemStack present = (ItemStack)this.items.get(i);
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty()) continue;
            if (present.isEmpty()) {
                this.items.set(i, (Object)stack);
                continue;
            }
            Epitaphs.LOGGER.warn("Soulbound item {} could not be saved to inventory because data was already occupied with {}. Did some mod kill us twice?", (Object)stack, (Object)present);
            player.getInventory().add(stack);
        }
    }

    public void setArmor(ServerPlayer player, NonNullList<ItemStack> armor) {
        if (this.armor.isEmpty() || this.armor.size() != armor.size()) {
            this.armor = armor;
            return;
        }
        for (int i = 0; i < armor.size(); ++i) {
            ItemStack present = (ItemStack)this.armor.get(i);
            ItemStack stack = (ItemStack)armor.get(i);
            if (stack.isEmpty()) continue;
            if (present.isEmpty()) {
                this.armor.set(i, (Object)stack);
                continue;
            }
            Epitaphs.LOGGER.warn("Soulbound item {} could not be saved to armor because data was already occupied with {}. Did some mod kill us twice?", (Object)stack, (Object)present);
            player.getInventory().add(stack);
        }
    }

    public void setOffhand(ServerPlayer player, NonNullList<ItemStack> offhand) {
        if (this.offhand.isEmpty() || this.offhand.size() != offhand.size()) {
            this.offhand = offhand;
            return;
        }
        for (int i = 0; i < offhand.size(); ++i) {
            if (i >= this.offhand.size()) {
                this.offhand.add((Object)ItemStack.EMPTY);
            }
            ItemStack present = (ItemStack)this.offhand.get(i);
            ItemStack stack = (ItemStack)offhand.get(i);
            if (stack.isEmpty()) continue;
            if (present.isEmpty()) {
                this.offhand.set(i, (Object)stack);
                continue;
            }
            Epitaphs.LOGGER.warn("Soulbound item {} could not be saved to offhand because data was already occupied with {}. Did some mod kill us twice?", (Object)stack, (Object)present);
            player.getInventory().add(stack);
        }
    }

    public void setCurio(ServerPlayer player, List<ItemStack> curio, List<ItemStack> cosmetics) {
        ItemStack stack;
        ItemStack present;
        int i;
        if ((this.curio.isEmpty() || this.curio.size() != curio.size()) && (this.cosmetics.isEmpty() || this.cosmetics.size() != cosmetics.size())) {
            this.curio = curio;
            this.cosmetics = cosmetics;
            return;
        }
        for (i = 0; i < curio.size(); ++i) {
            present = this.curio.get(i);
            stack = curio.get(i);
            if (stack.isEmpty()) continue;
            if (present.isEmpty()) {
                this.curio.set(i, stack);
                continue;
            }
            Epitaphs.LOGGER.warn("Soulbound item {} could not be saved to curio because data was already occupied with {}. Did some mod kill us twice?", (Object)stack, (Object)present);
            player.getInventory().add(stack);
        }
        for (i = 0; i < cosmetics.size(); ++i) {
            present = this.cosmetics.get(i);
            stack = cosmetics.get(i);
            if (stack.isEmpty()) continue;
            if (present.isEmpty()) {
                this.cosmetics.set(i, stack);
                continue;
            }
            Epitaphs.LOGGER.warn("Soulbound item {} could not be saved to cosmetics because data was already occupied with {}. Did some mod kill us twice?", (Object)stack, (Object)present);
            player.getInventory().add(stack);
        }
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public boolean isEmpty() {
        return this.items.isEmpty() && this.armor.isEmpty() && this.offhand.isEmpty() && this.curio.isEmpty();
    }

    public void clear() {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        this.curio.clear();
        this.experience = 0;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag data = new CompoundTag();
        CompoundTag itemsTag = new CompoundTag();
        ListTag itemsList = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("Slot", (byte)i);
            itemsList.add((Object)((ItemStack)this.items.get(i)).save(provider, (Tag)compoundtag));
        }
        itemsTag.put("Items", (Tag)itemsList);
        itemsTag.putInt("Count", this.items.size());
        data.put("items", (Tag)itemsTag);
        CompoundTag armorTag = new CompoundTag();
        ListTag armorList = new ListTag();
        for (int j = 0; j < this.armor.size(); ++j) {
            if (((ItemStack)this.armor.get(j)).isEmpty()) continue;
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.putByte("Slot", (byte)j);
            armorList.add((Object)((ItemStack)this.armor.get(j)).save(provider, (Tag)compoundtag1));
        }
        armorTag.put("Items", (Tag)armorList);
        armorTag.putInt("Count", this.armor.size());
        data.put("armor", (Tag)armorTag);
        CompoundTag offhandTag = new CompoundTag();
        ListTag offhandList = new ListTag();
        for (int k = 0; k < this.offhand.size(); ++k) {
            if (((ItemStack)this.offhand.get(k)).isEmpty()) continue;
            CompoundTag compoundtag2 = new CompoundTag();
            compoundtag2.putByte("Slot", (byte)k);
            offhandList.add((Object)((ItemStack)this.offhand.get(k)).save(provider, (Tag)compoundtag2));
        }
        offhandTag.put("Items", (Tag)offhandList);
        offhandTag.putInt("Count", this.offhand.size());
        data.put("offhand", (Tag)offhandTag);
        CompoundTag curioTag = new CompoundTag();
        ListTag curioList = new ListTag();
        for (int l = 0; l < this.curio.size(); ++l) {
            if (this.curio.get(l).isEmpty()) continue;
            CompoundTag compoundtag3 = new CompoundTag();
            compoundtag3.putByte("Slot", (byte)l);
            curioList.add((Object)this.curio.get(l).save(provider, (Tag)compoundtag3));
        }
        curioTag.put("Items", (Tag)curioList);
        curioTag.putInt("Count", this.curio.size());
        data.put("curio", (Tag)curioTag);
        if (this.experience > 0) {
            data.putInt("experience", this.experience);
        }
        return data;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ItemStack stack;
        int slot;
        CompoundTag tag;
        int i;
        int count;
        if (nbt.contains("items")) {
            CompoundTag itemsTag = nbt.getCompound("items");
            ListTag items = itemsTag.getList("Items", 10);
            count = itemsTag.getInt("Count");
            NonNullList itemStacks = NonNullList.withSize((int)count, (Object)ItemStack.EMPTY);
            for (i = 0; i < items.size(); ++i) {
                tag = items.getCompound(i);
                slot = tag.getByte("Slot") & 0xFF;
                stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
                itemStacks.set(slot, (Object)stack);
            }
            this.items = itemStacks;
        }
        if (nbt.contains("armor")) {
            CompoundTag armorTag = nbt.getCompound("armor");
            ListTag armor = armorTag.getList("Items", 10);
            count = armorTag.getInt("Count");
            NonNullList armorStacks = NonNullList.withSize((int)count, (Object)ItemStack.EMPTY);
            for (i = 0; i < armor.size(); ++i) {
                tag = armor.getCompound(i);
                slot = tag.getByte("Slot") & 0xFF;
                stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
                armorStacks.set(slot, (Object)stack);
            }
            this.armor = armorStacks;
        }
        if (nbt.contains("offhand")) {
            CompoundTag offhandTag = nbt.getCompound("offhand");
            ListTag offhand = offhandTag.getList("Items", 10);
            count = offhandTag.getInt("Count");
            NonNullList offhandStacks = NonNullList.withSize((int)count, (Object)ItemStack.EMPTY);
            for (i = 0; i < offhand.size(); ++i) {
                tag = offhand.getCompound(i);
                slot = tag.getByte("Slot") & 0xFF;
                stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
                offhandStacks.set(slot, (Object)stack);
            }
            this.offhand = offhandStacks;
        }
        if (nbt.contains("curio")) {
            CompoundTag curioTag = nbt.getCompound("curio");
            ListTag curio = curioTag.getList("Items", 10);
            count = curioTag.getInt("Count");
            NonNullList curioStacks = NonNullList.withSize((int)count, (Object)ItemStack.EMPTY);
            for (i = 0; i < curio.size(); ++i) {
                tag = curio.getCompound(i);
                slot = tag.getByte("Slot") & 0xFF;
                stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
                curioStacks.set(slot, (Object)stack);
            }
            this.curio = curioStacks;
        }
        if (nbt.contains("experience")) {
            this.experience = nbt.getInt("experience");
        }
    }
}

