/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.satherov.epitaphs.client.lang.EPLanguage;
import dev.satherov.epitaphs.common.component.EPLocationAttachment;
import dev.satherov.epitaphs.common.data.BackupHandler;
import dev.satherov.epitaphs.common.data.EBackupType;
import dev.satherov.epitaphs.core.EPRegistry;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerPlayer;

public class EPCommands {
    private static final SuggestionProvider<CommandSourceStack> FILE_SUGGESTER_PLAYER = (context, builder) -> {
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
        return EPCommands.getSuggestions(player.getStringUUID(), (CommandContext<CommandSourceStack>)context, builder);
    };
    private static final SuggestionProvider<CommandSourceStack> FILE_SUGGESTER_UUID = (context, builder) -> {
        String uuid = StringArgumentType.getString((CommandContext)context, (String)"uuid");
        return EPCommands.getSuggestions(uuid, (CommandContext<CommandSourceStack>)context, builder);
    };
    private static final SuggestionProvider<CommandSourceStack> UUID_SUGGESTER = (context, builder) -> {
        LinkedList<String> files = BackupHandler.listPlayers(((CommandSourceStack)context.getSource()).getServer());
        files.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"epitaphs").then(EPCommands.recoverCommand())).then(EPCommands.backupCommand())).then(EPCommands.listCommand())).then(EPCommands.latestCommand())).then(EPCommands.filesCommand())).then(EPCommands.uuidCommand()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> recoverCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"recover").requires(cs -> cs.hasPermission(4))).then(Commands.literal((String)"player").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"timestamp", (ArgumentType)StringArgumentType.string()).suggests(FILE_SUGGESTER_PLAYER).executes(ctx -> EPCommands.recoverPlayer((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"timestamp"), false))).then(Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> EPCommands.recoverPlayer((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"timestamp"), BoolArgumentType.getBool((CommandContext)ctx, (String)"force")))))).executes(ctx -> EPCommands.recoverPlayer((CommandContext<CommandSourceStack>)ctx, null, false))))).then(Commands.literal((String)"uuid").then(((RequiredArgumentBuilder)Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests(UUID_SUGGESTER).then(((RequiredArgumentBuilder)Commands.argument((String)"timestamp", (ArgumentType)StringArgumentType.string()).suggests(FILE_SUGGESTER_UUID).executes(ctx -> EPCommands.recoverUUID((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"timestamp"), false))).then(Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> EPCommands.recoverUUID((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"timestamp"), BoolArgumentType.getBool((CommandContext)ctx, (String)"force")))))).executes(ctx -> EPCommands.recoverUUID((CommandContext<CommandSourceStack>)ctx, null, false))));
    }

    private static int recoverUUID(CommandContext<CommandSourceStack> ctx, String timestamp, boolean force) {
        String uuid = StringArgumentType.getString(ctx, (String)"uuid");
        return EPCommands.recover(ctx, uuid, timestamp, force);
    }

    private static int recoverPlayer(CommandContext<CommandSourceStack> ctx, String timestamp, boolean force) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        return EPCommands.recover(ctx, player.getStringUUID(), timestamp, force);
    }

    private static int recover(CommandContext<CommandSourceStack> ctx, String uuid, String timestamp, boolean force) {
        String user;
        int result = BackupHandler.restoreCommand(((CommandSourceStack)ctx.getSource()).getServer(), (CommandSourceStack)ctx.getSource(), uuid, timestamp, force);
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(UUID.fromString(uuid));
        String string = user = player == null ? uuid : player.getName().getString();
        if (result == 0) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)EPLanguage.COMMAND_RESTORE_SUCCESS.translate(user));
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)EPLanguage.COMMAND_RESTORE_FAILED.translate(user));
        }
        return result;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> backupCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"save").requires(cs -> cs.hasPermission(4))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(EPCommands::save));
    }

    private static int save(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(ctx, (String)"players");
        for (ServerPlayer player : players) {
            int result = BackupHandler.save(player, DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").withZone(ZoneOffset.UTC).format(Instant.now()), EBackupType.SAVE);
            if (result == 0) continue;
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)EPLanguage.COMMAND_BACKUP_FAILED.translate(player.getDisplayName()));
            return -1;
        }
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)EPLanguage.COMMAND_BACKUP_SUCCESS.translate());
        return 0;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> listCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> EPCommands.list((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(cs -> cs.hasPermission(4))).executes(ctx -> EPCommands.list((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))));
    }

    private static int list(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        Map<String, List<Map.Entry<String, BlockPos>>> locations = ((EPLocationAttachment)player.getData(EPRegistry.LOCATION_DATA)).getGraveLocations(player.serverLevel());
        if (locations.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)EPLanguage.COMMAND_NOT_FOUND.translate(player.getDisplayName()).withStyle(ChatFormatting.RED));
            return 0;
        }
        locations.forEach((dimension, list) -> {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)dimension).append(":").withStyle(ChatFormatting.GOLD));
            list.forEach(entry -> {
                BlockPos gravePos = ((BlockPos)entry.getValue()).immutable();
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.empty().append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)((String)entry.getKey())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append((Component)ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{gravePos.getX(), gravePos.getY(), gravePos.getZ()})).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in %s run tp @s %s %s %s".formatted(dimension, gravePos.getX(), gravePos.getY(), gravePos.getZ())))).withStyle(ChatFormatting.AQUA)));
            });
        });
        return 0;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> latestCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"latest").executes(ctx -> EPCommands.latest((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(cs -> cs.hasPermission(4))).executes(ctx -> EPCommands.latest((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))));
    }

    private static int latest(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        ((EPLocationAttachment)player.getData(EPRegistry.LOCATION_DATA)).findLatestGraveLocation(player.serverLevel()).ifPresentOrElse(entry -> {
            BlockPos pos = entry.pos().immutable();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.empty().append((Component)Component.literal((String)entry.dimension().location().toString()).append(":").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append((Component)ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()})).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in %s run tp @s %s %s %s".formatted(entry.dimension().location(), pos.getX(), pos.getY(), pos.getZ())))).withStyle(ChatFormatting.AQUA)));
        }, () -> ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)EPLanguage.COMMAND_NOT_FOUND.translate(player.getDisplayName()).withStyle(ChatFormatting.RED)));
        return 0;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> filesCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"files").requires(ctx -> ctx.hasPermission(2))).then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> EPCommands.files((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player").getStringUUID()))))).then(Commands.literal((String)"uuid").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests(UUID_SUGGESTER).executes(ctx -> EPCommands.files((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"uuid")))));
    }

    private static int files(CommandContext<CommandSourceStack> ctx, String player) {
        LinkedList<String> files = BackupHandler.listBackups(((CommandSourceStack)ctx.getSource()).getServer(), player);
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Available backups for ").append((Component)Component.literal((String)player).withStyle(ChatFormatting.GREEN)));
        files.forEach(file -> ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"- ").append((Component)Component.literal((String)file).withStyle(ChatFormatting.GRAY))));
        return 0;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> uuidCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"uuid").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> EPCommands.uuid((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(ctx -> EPCommands.uuid((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException()));
    }

    private static int uuid(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("%s has the UUID: ", player.getGameProfile().getName())).append((Component)Component.literal((String)player.getStringUUID()).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, player.getStringUUID()))).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.GRAY));
        return 0;
    }

    private static CompletableFuture<Suggestions> getSuggestions(String uuid, CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        LinkedList<String> files = BackupHandler.listBackups(((CommandSourceStack)context.getSource()).getServer(), uuid);
        files.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

