/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.block;

import dev.satherov.epitaphs.Epitaphs;
import dev.satherov.epitaphs.common.component.EPGraveDataAttachment;
import dev.satherov.epitaphs.common.data.BackupHandler;
import dev.satherov.epitaphs.common.tile.GraveBlockEntity;
import dev.satherov.epitaphs.core.EPRegistry;
import dev.satherov.epitaphs.core.annotations.NothingNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@NothingNull
public class GraveBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final VoxelShape SHAPE = Shapes.or((VoxelShape)GraveBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{GraveBlock.box((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0), GraveBlock.box((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)14.0, (double)2.0), GraveBlock.box((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0)});

    public GraveBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(-1.0f, Float.MAX_VALUE));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return player.isCreative();
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return player.isCreative() ? super.getDestroyProgress(state, player, blockGetter, pos) : 0.0f;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return false;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new GraveBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        if (state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, isMoving);
            return;
        }
        this.cleanup(level, pos, true);
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void cleanup(ServerLevel level, BlockPos pos, boolean drop) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return;
        }
        GraveBlockEntity grave = (GraveBlockEntity)blockEntity;
        MinecraftServer server = level.getServer();
        EPGraveDataAttachment data = (EPGraveDataAttachment)grave.getData(EPRegistry.GRAVE_DATA);
        String uuid = data.getOwner();
        String timestamp = data.getTimestamp();
        if (uuid.isBlank() || timestamp.isBlank()) {
            Epitaphs.LOGGER.debug("Grave at '{}' has incomplete data, skipping cleanup", (Object)grave.getBlockPos());
            return;
        }
        Path storage = server.getWorldPath(LevelResource.ROOT).normalize().toAbsolutePath().resolve("data").resolve("epitaphs").resolve(uuid);
        try {
            Path death = storage.resolve(timestamp + "-death.dat");
            Files.move(death, storage.resolve(timestamp + "-death.dat-old"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Epitaphs.LOGGER.error("Failed to rename old death data for '{}'", (Object)uuid, (Object)e);
        }
        if (drop) {
            List<ItemStack> contents = BackupHandler.getContents(server, uuid, timestamp);
            for (ItemStack stack : contents) {
                if (stack.isEmpty()) continue;
                ItemEntity entity = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
                level.addFreshEntity((Entity)entity);
            }
        }
    }

    public static Optional<BlockPos> findSafeSpot(ServerLevel level, BlockPos grave) {
        BlockPos origin = new BlockPos(grave.getX(), Mth.clamp((int)grave.getY(), (int)(level.getMinBuildHeight() + 1), (int)level.getMaxBuildHeight()), grave.getZ()).immutable();
        ArrayList stableCandidates = new ArrayList();
        ArrayList fallbackCandidates = new ArrayList();
        level.getChunk(origin).findBlocks(state -> state.is(BlockTags.REPLACEABLE), (state, pos) -> state.is(BlockTags.REPLACEABLE), (pos, state) -> {
            BlockPos candidate = pos.immutable();
            if (!level.getBlockState(pos.below()).is(BlockTags.REPLACEABLE)) {
                stableCandidates.add(candidate);
            } else {
                fallbackCandidates.add(candidate);
            }
        });
        Optional<BlockPos> stableResult = stableCandidates.stream().min(Comparator.comparingDouble(arg_0 -> ((BlockPos)origin).distSqr(arg_0)));
        if (stableResult.isPresent()) {
            return stableResult;
        }
        return fallbackCandidates.stream().min(Comparator.comparingDouble(arg_0 -> ((BlockPos)origin).distSqr(arg_0)));
    }
}

