/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.api.event.CustomFilterDisplayItemsEvent;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Int2ObjectLinkedOpenHashMap<List<ItemStack>> cache = new Int2ObjectLinkedOpenHashMap(1024);
    private static List<ItemStack> extraCache = null;

    @NotNull
    public static List<ItemStack> getCachedDisplayStacks(ItemStack filterStack, ItemFilterAdapter adapter, HolderLookup.Provider registryAccess) {
        int key = ItemStack.hashItemAndComponents((ItemStack)filterStack);
        List<ItemStack> result = (List<ItemStack>)cache.getAndMoveToFirst(key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(adapter.getMatcher(filterStack, registryAccess));
            cache.put(key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<ItemStack> computeMatchingStacks(ItemFilterAdapter.Matcher matcher) {
        FTBQuestsClient.creativeTabDisplayParams().ifPresent(params -> {
            if (CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)params.enabledFeatures(), (boolean)params.hasPermissions(), (HolderLookup.Provider)params.holders())) {
                FTBQuests.LOGGER.debug("creative tabs rebuilt, search tab now has {} items", (Object)CreativeModeTabs.searchTab().getSearchTabDisplayItems().size());
            }
        });
        ImmutableList.Builder builder = ImmutableList.builder();
        CreativeModeTabs.searchTab().getSearchTabDisplayItems().stream().filter(matcher).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        DisplayStacksCache.getExtraDisplayCache().stream().filter(matcher).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void clear() {
        cache.clear();
        extraCache = null;
    }

    @NotNull
    private static List<ItemStack> getExtraDisplayCache() {
        if (extraCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ((Consumer)CustomFilterDisplayItemsEvent.ADD_ITEMSTACK.invoker()).accept(new CustomFilterDisplayItemsEvent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)));
            extraCache = builder.build();
        }
        return extraCache;
    }
}

