/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;
import reliquary.entity.ReliquaryFakePlayer;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.util.FakePlayerFactory;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;

public class ShearsOfWinterItem
extends ShearsItem
implements ICreativeTabItemGenerator {
    public ShearsOfWinterItem() {
        super(new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof BeehiveBlock) {
            this.shearBeehive(level, pos, state, context.getClickLocation(), context.getClickedFace());
        }
        return super.useOn(context);
    }

    private void shearBeehive(Level level, BlockPos pos, BlockState state, Vec3 hitVec, Direction face) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ItemStack fakeShears = new ItemStack((ItemLike)Items.SHEARS);
        ReliquaryFakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, fakeShears);
        state.useItemOn(fakeShears, level, (Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(hitVec, face, pos, false));
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 2500;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (this.getUseDuration(stack, livingEntity) - remainingUseDuration <= 5 || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Vec3 lookVector = player.getLookAngle();
        this.spawnBlizzardParticles(lookVector, player);
        if (livingEntity.level().isClientSide) {
            return;
        }
        this.doEntityShearableCheck(stack, player, lookVector);
        this.shearBlocks(player, lookVector);
    }

    private void shearBlocks(Player player, Vec3 lookVector) {
        Vec3 eyePosition = player.getEyePosition(1.0f);
        BlockPos firstPos = BlockPos.containing((Position)eyePosition);
        BlockPos secondPos = BlockPos.containing((Position)eyePosition.add(lookVector.multiply(10.0, 10.0, 10.0)));
        if (firstPos.getX() == secondPos.getX()) {
            firstPos = firstPos.offset(-2, 0, 0);
            secondPos = secondPos.offset(2, 0, 0);
        }
        if (firstPos.getY() == secondPos.getY()) {
            firstPos = firstPos.offset(0, -2, 0);
            secondPos = secondPos.offset(0, 2, 0);
        }
        if (firstPos.getZ() == secondPos.getZ()) {
            firstPos = firstPos.offset(0, 0, -2);
            secondPos = secondPos.offset(0, 0, 2);
        }
        BlockPos.betweenClosedStream((BlockPos)firstPos, (BlockPos)secondPos).forEach(pos -> this.checkAndShearBlockAt(player, (BlockPos)pos));
    }

    public void appendHoverText(ItemStack shears, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder.of(tooltip, context).itemTooltip((Item)this);
    }

    private void checkAndShearBlockAt(Player player, BlockPos pos) {
        int distance = (int)Math.sqrt(pos.distToLowCornerSqr(player.getX(), player.getY(), player.getZ()));
        int probabilityFactor = 5 + distance;
        if (player.level().random.nextInt(probabilityFactor) == 0) {
            this.shearBlockAt(pos, player);
        }
    }

    private void shearBlockAt(BlockPos pos, Player player) {
        Level level = player.level();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof IShearable) {
            IShearable target = (IShearable)block;
            ItemStack dummyShears = new ItemStack((ItemLike)Items.SHEARS);
            if (target.isShearable(player, dummyShears, level, pos) && this.removeBlock(player, pos, blockState.canHarvestBlock((BlockGetter)level, pos, player))) {
                player.awardStat(Stats.BLOCK_MINED.get((Object)block));
                player.causeFoodExhaustion(0.01f);
                Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)dummyShears);
            }
        } else if (block instanceof BeehiveBlock) {
            this.shearBeehive(level, pos, blockState, Vec3.ZERO, Direction.UP);
        }
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.shearBlockAt(pos, player);
        }
        return super.mineBlock(stack, level, state, pos, livingEntity);
    }

    private boolean removeBlock(Player player, BlockPos pos, boolean canHarvest) {
        BlockState state = player.level().getBlockState(pos);
        boolean removed = state.onDestroyedByPlayer(player.level(), pos, player, canHarvest, player.level().getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)player.level(), pos, state);
        }
        return removed;
    }

    private void doEntityShearableCheck(ItemStack stack, Player player, Vec3 lookVector) {
        if (player.level().isClientSide) {
            return;
        }
        double lowerX = Math.min(player.getX(), player.getX() + lookVector.x * 10.0);
        double lowerY = Math.min(player.getY() + (double)player.getEyeHeight(), player.getY() + (double)player.getEyeHeight() + lookVector.y * 10.0);
        double lowerZ = Math.min(player.getZ(), player.getZ() + lookVector.z * 10.0);
        double upperX = Math.max(player.getX(), player.getX() + lookVector.x * 10.0);
        double upperY = Math.max(player.getY() + (double)player.getEyeHeight(), player.getY() + (double)player.getEyeHeight() + lookVector.y * 10.0);
        double upperZ = Math.max(player.getZ(), player.getZ() + lookVector.z * 10.0);
        List eList = player.level().getEntitiesOfClass(Mob.class, new AABB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ));
        RandomSource rand = player.level().random;
        for (Mob e : eList) {
            int distance = (int)player.distanceTo((Entity)e);
            int probabilityFactor = (distance - 3) / 2;
            if (probabilityFactor > 0 && player.level().random.nextInt(probabilityFactor) != 0) continue;
            if (!e.is((Entity)player)) {
                e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1));
            }
            if (!(e instanceof IShearable)) continue;
            this.shearEntity(stack, player, rand, e);
        }
    }

    private void shearEntity(ItemStack stack, Player player, RandomSource rand, Mob e) {
        IShearable target = (IShearable)e;
        BlockPos pos = e.blockPosition();
        if (target.isShearable(player, new ItemStack((ItemLike)Items.SHEARS), e.level(), pos)) {
            List drops = target.onSheared(player, stack, e.level(), pos);
            drops.forEach(d -> {
                ItemEntity ent = e.spawnAtLocation(d, 1.0f);
                if (ent != null) {
                    ent.setDeltaMovement(ent.getDeltaMovement().add((double)(RandHelper.getRandomMinusOneToOne(rand) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)(RandHelper.getRandomMinusOneToOne(rand) * 0.1f)));
                }
            });
            player.causeFoodExhaustion(0.01f);
        }
    }

    private void spawnBlizzardParticles(Vec3 lookVector, Player player) {
        BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState());
        for (int i = 0; i < 16; ++i) {
            float randX = 10.0f * (player.level().random.nextFloat() - 0.5f);
            float randY = 10.0f * (player.level().random.nextFloat() - 0.5f);
            float randZ = 10.0f * (player.level().random.nextFloat() - 0.5f);
            player.level().addParticle((ParticleOptions)blockParticleData, player.getX() + (double)randX, player.getY() + (double)randY, player.getZ() + (double)randZ, lookVector.x * 5.0, lookVector.y * 5.0, lookVector.z * 5.0);
        }
    }
}

