/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModDataComponents;
import reliquary.item.ToggleableItem;
import reliquary.item.component.OversizedComponentItemHandler;
import reliquary.item.component.OversizedItemContainerContents;
import reliquary.util.InventoryHelper;

public abstract class ChargeableItem
extends ToggleableItem {
    public static final PrimitiveCodec<Integer> STRING_ENCODED_INT = new PrimitiveCodec<Integer>(){

        public <T> DataResult<Integer> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(s -> {
                if (s.startsWith("i")) {
                    return Integer.parseInt(s.substring(1));
                }
                return Integer.parseInt(s);
            });
        }

        public <T> T write(DynamicOps<T> ops, Integer value) {
            return (T)ops.createString("i" + value);
        }

        public String toString() {
            return "Int";
        }
    };
    public static final Codec<Map<Integer, Integer>> PARTIAL_CHARGES_CODEC = Codec.unboundedMap(STRING_ENCODED_INT, (Codec)ExtraCodecs.NON_NEGATIVE_INT);
    public static final StreamCodec<FriendlyByteBuf, Map<Integer, Integer>> PARTIAL_CHARGES_STREAM_CODEC = StreamCodec.of((buf, map) -> buf.writeMap(map, (StreamEncoder)ByteBufCodecs.INT, (StreamEncoder)ByteBufCodecs.INT), buf -> buf.readMap((StreamDecoder)ByteBufCodecs.INT, (StreamDecoder)ByteBufCodecs.INT));
    protected static final int FIRST_SLOT = 0;

    protected ChargeableItem(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties, isDisabled);
    }

    protected ChargeableItem(Item.Properties properties) {
        this(properties, () -> false);
    }

    protected <T> T getFromHandler(ItemStack stack, Function<OversizedComponentItemHandler, T> getter) {
        return getter.apply(this.createHandler(stack));
    }

    protected void runOnHandler(ItemStack stack, Consumer<OversizedComponentItemHandler> runner) {
        runner.accept(this.createHandler(stack));
    }

    public OversizedComponentItemHandler createHandler(ItemStack containerStack) {
        int size = Math.max(containerStack.has(ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS) ? ((OversizedItemContainerContents)containerStack.get(ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS)).getSlots() : this.getContainerInitialSize(), this.getContainerInitialSize());
        return new OversizedComponentItemHandler(containerStack, ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS.get(), size, this::getContainerSlotLimit, (slot, stack) -> this.isItemValidForContainerSlot(containerStack, (int)slot, (ItemStack)stack));
    }

    protected int getSlotWorth(int slot) {
        return 1;
    }

    protected void removeContainerContents(ItemStack stack) {
        stack.remove(ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS);
    }

    protected int getContainerInitialSize() {
        return 1;
    }

    protected int getContainerSlotLimit(ItemStack stack, int slot) {
        return this.getContainerSlotLimit(slot);
    }

    protected int getContainerSlotLimit(int slot) {
        return 64;
    }

    protected abstract boolean isItemValidForContainerSlot(ItemStack var1, int var2, ItemStack var3);

    protected void consumeAndCharge(ItemStack containerStack, int slot, Player player, int freeCapacity, int chargePerItem, int maxCount) {
        Predicate<ItemStack> isValidStack = stack -> this.isItemValidForContainerSlot(containerStack, slot, (ItemStack)stack);
        this.consumeAndCharge(containerStack, slot, player, freeCapacity, chargePerItem, maxCount, isValidStack);
    }

    protected void consumeAndCharge(ItemStack containerStack, int slot, Player player, int freeCapacity, int chargePerItem, int maxCount, Predicate<ItemStack> itemMatches) {
        int maximumToConsume = Math.min(freeCapacity / chargePerItem, maxCount);
        if (maximumToConsume == 0) {
            return;
        }
        ItemStack consumedStack = InventoryHelper.consumeItemStack(itemMatches, player, maximumToConsume);
        if (consumedStack.getCount() > 0) {
            this.addStoredCharge(containerStack, slot, consumedStack.getCount() * chargePerItem, consumedStack);
            if (!containerStack.has(ModDataComponents.PARTIAL_CHARGES)) {
                HashMap<Integer, Integer> charges = new HashMap<Integer, Integer>();
                charges.put(slot, 0);
                this.setPartialCharges(containerStack, charges);
            }
        }
    }

    private int getPartialCharge(ItemStack containerStack, int slot) {
        Map charges = (Map)containerStack.get(ModDataComponents.PARTIAL_CHARGES);
        if (charges != null) {
            return charges.getOrDefault(slot, 0);
        }
        return 0;
    }

    protected int getTotalCharge(ItemStack containerStack) {
        return this.getTotalCharge(containerStack, 0);
    }

    protected int getTotalCharge(ItemStack containerStack, int slot) {
        return this.getMigratedStoredCharge(containerStack, slot) * this.getSlotWorth(slot) + this.getPartialCharge(containerStack, slot);
    }

    private void setPartialCharge(ItemStack containerStack, int slot, int charge) {
        HashMap<Integer, Integer> charges = (HashMap<Integer, Integer>)containerStack.get(ModDataComponents.PARTIAL_CHARGES);
        charges = charges != null ? new HashMap<Integer, Integer>(charges) : new HashMap();
        charges.put(slot, charge);
        this.setPartialCharges(containerStack, charges);
    }

    private void removePartialCharge(ItemStack containerStack, int slot) {
        HashMap<Integer, Integer> charges = (HashMap<Integer, Integer>)containerStack.get(ModDataComponents.PARTIAL_CHARGES);
        if (charges != null && charges.containsKey(slot)) {
            charges = new HashMap<Integer, Integer>(charges);
            charges.remove(slot);
            this.setPartialCharges(containerStack, charges);
        }
    }

    protected boolean addPartialCharge(ItemStack containerStack, int slot, int chargeToAdd) {
        int fullCharges;
        int worth;
        boolean updatedEitherCharge = false;
        int currentCharge = this.getPartialCharge(containerStack, slot);
        int updatedPartialCharge = currentCharge + chargeToAdd;
        if (updatedPartialCharge >= (worth = this.getSlotWorth(slot)) && (fullCharges = Math.min(updatedPartialCharge / worth, this.getContainerSlotLimit(containerStack, slot) - this.getMigratedStoredCharge(containerStack, slot))) > 0) {
            updatedEitherCharge = true;
            this.addStoredCharge(containerStack, slot, fullCharges, null);
            updatedPartialCharge = Math.min(updatedPartialCharge - fullCharges * worth, worth - 1);
        }
        this.setPartialCharge(containerStack, slot, updatedPartialCharge);
        return updatedEitherCharge |= updatedPartialCharge != currentCharge;
    }

    private void setPartialCharges(ItemStack containerStack, Map<Integer, Integer> charges) {
        containerStack.set(ModDataComponents.PARTIAL_CHARGES, (Object)ImmutableMap.copyOf(charges));
    }

    public abstract void addStoredCharge(ItemStack var1, int var2, int var3, @Nullable ItemStack var4);

    protected void extractStoredCharge(ItemStack containerStack, int slot, int chargeToExtract) {
        this.addStoredCharge(containerStack, slot, -chargeToExtract, null);
    }

    protected int getMigratedStoredCharge(ItemStack containerStack, int slot) {
        int storedCharge = this.getStoredCharge(containerStack, slot);
        if (!containerStack.has(ModDataComponents.PARTIAL_CHARGES) && storedCharge > 0) {
            storedCharge = this.migrateLegacyChargeData(containerStack, slot, storedCharge);
        }
        return storedCharge;
    }

    public abstract int getStoredCharge(ItemStack var1, int var2);

    protected boolean removeSlotWhenEmpty(int slot) {
        return false;
    }

    protected void removeSlot(ItemStack containerStack, int slot) {
    }

    private int migrateLegacyChargeData(ItemStack containerStack, int slot, int storedCharge) {
        int newStoredCharge = storedCharge / this.getSlotWorth(slot);
        this.extractStoredCharge(containerStack, slot, storedCharge - newStoredCharge);
        this.setPartialCharge(containerStack, slot, storedCharge % this.getSlotWorth(slot));
        return newStoredCharge;
    }

    public boolean useCharge(ItemStack containerStack, int chargeToUse) {
        return this.useCharge(containerStack, 0, chargeToUse);
    }

    public boolean useCharge(ItemStack containerStack, int slot, int chargeToUse) {
        int worth;
        int partialCharge = this.getPartialCharge(containerStack, slot);
        if (partialCharge >= chargeToUse) {
            if (partialCharge == chargeToUse) {
                this.removePartialCharge(containerStack, slot);
            } else {
                this.setPartialCharge(containerStack, slot, partialCharge - chargeToUse);
            }
            return true;
        }
        int charge = this.getMigratedStoredCharge(containerStack, slot);
        if (charge * (worth = this.getSlotWorth(slot)) + partialCharge >= chargeToUse) {
            int additionalPartialChargeNeeded = chargeToUse - partialCharge;
            int actualChargeToRemove = additionalPartialChargeNeeded / worth + (additionalPartialChargeNeeded % worth > 0 ? 1 : 0);
            int partialChargeToAdd = actualChargeToRemove * worth - chargeToUse;
            if (actualChargeToRemove == charge && this.removeSlotWhenEmpty(slot)) {
                this.removeSlot(containerStack, slot);
            } else {
                this.extractStoredCharge(containerStack, slot, actualChargeToRemove);
            }
            int newPartialCharge = partialCharge + partialChargeToAdd;
            if (newPartialCharge > 0) {
                this.setPartialCharge(containerStack, slot, newPartialCharge);
            } else {
                this.removePartialCharge(containerStack, slot);
            }
            return true;
        }
        return false;
    }

    protected boolean addItemToContainer(ItemStack container, Item item, int chargeToAdd) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.setCount(chargeToAdd);
        return this.getFromHandler(container, handler -> handler.insertItemOrAddIntoNewSlotIfNoStackMatches(stack)).isEmpty();
    }

    public boolean removeItemFromInternalStorage(ItemStack stack, int slot, int quantityToRemove, boolean simulate, Player player) {
        if (player.isCreative()) {
            return true;
        }
        return this.getFromHandler(stack, handler -> handler.extractItemAndRemoveSlotIfEmpty(slot, quantityToRemove, simulate)).getCount() == quantityToRemove;
    }
}

