/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.reference.Config;

public class LyssaHook
extends FishingHook {
    public LyssaHook(EntityType<LyssaHook> entityType, Level level) {
        this(entityType, level, 0, 0);
    }

    private LyssaHook(EntityType<LyssaHook> entityType, Level level, int luck, int lureSpeed) {
        super(entityType, level, luck, lureSpeed);
    }

    public LyssaHook(Level level, Player fishingPlayer, int lureSpeed, int luck) {
        this(ModEntities.LYSSA_HOOK.get(), level, luck, lureSpeed);
        this.setOwner((Entity)fishingPlayer);
        this.shoot(fishingPlayer);
        this.speedUp();
    }

    private void shoot(Player fishingPlayer) {
        float f = fishingPlayer.getXRot();
        float f1 = fishingPlayer.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = fishingPlayer.getX() - (double)f3 * 0.3;
        double d1 = fishingPlayer.getEyeY();
        double d2 = fishingPlayer.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045);
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 16384.0;
    }

    public Optional<Player> getFishingPlayer() {
        Player player;
        Entity entity = this.getOwner();
        return Optional.ofNullable(entity instanceof Player ? (player = (Player)entity) : null);
    }

    private void speedUp() {
        if (this.getDeltaMovement().y() >= 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(2.0, 2.0, 2.0));
        }
    }

    public void tick() {
        super.tick();
        this.pullItemEntitiesTowardsHook();
    }

    protected boolean shouldStopFishing(Player fishingPlayer) {
        boolean flag1;
        ItemStack itemstack = fishingPlayer.getMainHandItem();
        ItemStack itemstack1 = fishingPlayer.getOffhandItem();
        boolean flag = itemstack.getItem() == ModItems.ROD_OF_LYSSA.get();
        boolean bl = flag1 = itemstack1.getItem() == ModItems.ROD_OF_LYSSA.get();
        if (fishingPlayer.isAlive() && (flag || flag1) && this.distanceToSqr((Entity)fishingPlayer) <= 10240.0) {
            return false;
        }
        this.discard();
        return true;
    }

    private void pullItemEntitiesTowardsHook() {
        if (this.isAlive() && this.getHookedIn() == null) {
            float f = 0.0f;
            BlockPos blockpos = this.blockPosition();
            FluidState fluidState = this.level().getFluidState(blockpos);
            if (fluidState.is(FluidTags.WATER)) {
                f = fluidState.getHeight((BlockGetter)this.level(), blockpos);
            }
            if (f <= 0.0f) {
                List list = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(3.0));
                for (ItemEntity e : list) {
                    Vec3 pullVector = new Vec3(this.getX() - e.getX(), this.getY() - e.getY(), this.getZ() - e.getZ()).normalize();
                    e.setDeltaMovement(pullVector.multiply(0.4, 0.4, 0.4));
                }
            }
        }
    }

    public void handleHookRetraction(ItemStack stack) {
        if (!this.level().isClientSide) {
            Entity hookedIn = this.getHookedIn();
            if (hookedIn != null && this.getFishingPlayer().map(Entity::isCrouching).orElse(false).booleanValue() && this.canStealFromEntity()) {
                this.stealFromLivingEntity();
                this.discard();
            } else if (!this.level().isClientSide && this.getFishingPlayer().isPresent() && hookedIn != null) {
                this.bringInHookedEntity();
                this.level().broadcastEntityEvent((Entity)this, (byte)31);
                this.discard();
            } else {
                super.retrieve(stack);
            }
            this.pullItemEntitiesWithHook();
        }
    }

    private void bringInHookedEntity() {
        Entity hookedIn = this.getHookedIn();
        if (hookedIn != null) {
            super.pullEntity(hookedIn);
        }
        if (hookedIn instanceof ItemEntity) {
            hookedIn.setDeltaMovement(hookedIn.getDeltaMovement().multiply(4.0, 4.0, 4.0));
        } else if (hookedIn instanceof LivingEntity) {
            hookedIn.setDeltaMovement(hookedIn.getDeltaMovement().multiply(1.0, 1.5, 1.0));
        }
    }

    private boolean canStealFromEntity() {
        Entity hookedIn = this.getHookedIn();
        return hookedIn instanceof LivingEntity && ((Boolean)Config.COMMON.items.rodOfLyssa.stealFromPlayers.get() != false || !(hookedIn instanceof Player)) && Config.COMMON.items.rodOfLyssa.canStealFromEntity(hookedIn);
    }

    private void pullItemEntitiesWithHook() {
        List pullingItemsList = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0, 1.0, 1.0));
        this.getFishingPlayer().ifPresent(p -> {
            for (ItemEntity e : pullingItemsList) {
                double d1 = p.getX() - this.getX();
                double d3 = p.getY() - this.getY();
                double d5 = p.getZ() - this.getZ();
                double d7 = Math.sqrt(d1 * d1 + d3 * d3 + d5 * d5);
                double d9 = 0.1;
                e.setDeltaMovement(d1 * d9, d3 * d9 + Math.sqrt(d7) * 0.08, d5 * d9);
            }
        });
    }

    private void stealFromLivingEntity() {
        Level level;
        Optional<Player> p;
        Entity entity = this.getHookedIn();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        EquipmentSlot slotBeingStolenFrom = EquipmentSlot.values()[this.level().random.nextInt(EquipmentSlot.values().length)];
        ItemStack stolenStack = livingEntity.getItemBySlot(slotBeingStolenFrom);
        if (stolenStack.isEmpty() && Boolean.TRUE.equals(Config.COMMON.items.rodOfLyssa.stealFromVacantSlots.get())) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stolenStack = livingEntity.getItemBySlot(slot);
                if (stolenStack.isEmpty() || !this.canDropFromSlot(livingEntity, slot)) continue;
                slotBeingStolenFrom = slot;
                break;
            }
        }
        if ((p = this.getFishingPlayer()).isEmpty()) {
            return;
        }
        Player fishingPlayer = p.get();
        float failProbabilityFactor = Boolean.TRUE.equals(Config.COMMON.items.rodOfLyssa.useLeveledFailureRate.get()) ? 1.0f / ((float)Math.sqrt(Math.max(1, Math.min(fishingPlayer.experienceLevel, (Integer)Config.COMMON.items.rodOfLyssa.levelCapForLeveledFormula.get()))) * 2.0f) : (float)((Integer)Config.COMMON.items.rodOfLyssa.flatStealFailurePercentRate.get()).intValue() / 100.0f;
        if ((this.random.nextFloat() <= failProbabilityFactor || stolenStack.isEmpty() && ((Boolean)Config.COMMON.items.rodOfLyssa.failStealFromVacantSlots.get()).booleanValue()) && Boolean.TRUE.equals(Config.COMMON.items.rodOfLyssa.angerOnStealFailure.get())) {
            livingEntity.hurt(this.damageSources().playerAttack(fishingPlayer), 0.0f);
            return;
        }
        if (!stolenStack.isEmpty() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int randomItemDamage = this.level().random.nextInt(3);
            stolenStack.hurtAndBreak(randomItemDamage, serverLevel, livingEntity, e -> {});
            if (!stolenStack.isEmpty()) {
                ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stolenStack);
                entityitem.setPickUpDelay(5);
                double d1 = fishingPlayer.getX() - this.getX();
                double d3 = fishingPlayer.getY() - this.getY();
                double d5 = fishingPlayer.getZ() - this.getZ();
                double d7 = Math.sqrt(d1 * d1 + d3 * d3 + d5 * d5);
                double d9 = 0.1;
                entityitem.setDeltaMovement(d1 * d9, d3 * d9 + Math.sqrt(d7) * 0.08, d5 * d9);
                this.level().addFreshEntity((Entity)entityitem);
            }
            livingEntity.setItemSlot(slotBeingStolenFrom, ItemStack.EMPTY);
        }
    }

    private boolean canDropFromSlot(LivingEntity entity, EquipmentSlot slot) {
        if (!(entity instanceof Mob)) {
            return true;
        }
        Mob mob = (Mob)entity;
        if (slot.getType() == EquipmentSlot.Type.HAND) {
            return mob.handDropChances[slot.getIndex()] > -1.0f;
        }
        return mob.armorDropChances[slot.getIndex()] > -1.0f;
    }
}

