/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import reliquary.data.BlockTagProvider;
import reliquary.data.ItemTagProvider;
import reliquary.data.ModFluidTagsProvider;
import reliquary.data.ModRecipeProvider;
import reliquary.data.ReliquaryEnchantmentProvider;
import reliquary.data.ReliquaryEnchantmentTagsProvider;
import reliquary.data.ReliquaryLootModifierProvider;
import reliquary.data.ReliquaryLootTableProvider;

public class DataGenerators {
    private DataGenerators() {
    }

    public static void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        CompletableFuture registries = evt.getLookupProvider();
        DatapackBuiltinEntriesProvider builtinEntriesProvider = new DatapackBuiltinEntriesProvider(packOutput, evt.getLookupProvider(), new RegistrySetBuilder().add(Registries.ENCHANTMENT, ReliquaryEnchantmentProvider::bootstrap), Set.of("reliquary"));
        generator.addProvider(evt.includeServer(), (DataProvider)builtinEntriesProvider);
        generator.addProvider(evt.includeServer(), (DataProvider)new ReliquaryLootTableProvider(packOutput, builtinEntriesProvider.getRegistryProvider()));
        BlockTagProvider blockTagProvider = new BlockTagProvider(packOutput, registries, existingFileHelper);
        generator.addProvider(evt.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(evt.includeServer(), (DataProvider)new ItemTagProvider(packOutput, registries, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(evt.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, registries));
        generator.addProvider(evt.includeServer(), (DataProvider)new ModFluidTagsProvider(packOutput, registries, existingFileHelper));
        generator.addProvider(evt.includeServer(), (DataProvider)new ReliquaryLootModifierProvider(packOutput, registries));
        generator.addProvider(evt.includeServer(), (DataProvider)new ReliquaryEnchantmentTagsProvider(packOutput, builtinEntriesProvider.getRegistryProvider(), existingFileHelper));
    }
}

