/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import reliquary.crafting.FragmentRecipeHelper;
import reliquary.init.ModItems;
import reliquary.item.MobCharmItem;

public class MobCharmRecipe
extends ShapedRecipe {
    public static final Set<MobCharmRecipe> REGISTERED_RECIPES = new HashSet<MobCharmRecipe>();
    private final ShapedRecipe compose;

    public MobCharmRecipe(ShapedRecipe compose) {
        super(compose.getGroup(), CraftingBookCategory.MISC, compose.pattern, compose.result);
        this.compose = compose;
        REGISTERED_RECIPES.add(this);
    }

    public boolean matches(CraftingInput inv, Level level) {
        return super.matches(inv, level) && FragmentRecipeHelper.hasOnlyOneFragmentType(inv);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack ret = super.assemble(inv, registries);
        FragmentRecipeHelper.getRegistryName(inv).ifPresent(regName -> MobCharmItem.setEntityRegistryName(ret, regName));
        return ret;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModItems.MOB_CHARM_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<MobCharmRecipe> {
        private static final MapCodec<MobCharmRecipe> CODEC = RecipeSerializer.SHAPED_RECIPE.codec().xmap(MobCharmRecipe::new, recipe -> recipe.compose);
        private static final StreamCodec<RegistryFriendlyByteBuf, MobCharmRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(MobCharmRecipe::new, recipe -> recipe.compose);

        public MapCodec<MobCharmRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MobCharmRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

