/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import com.starfish_studios.another_furniture.block.CurtainBlock;
import com.starfish_studios.another_furniture.block.LampBlock;
import com.starfish_studios.another_furniture.block.SofaBlock;
import com.starfish_studios.another_furniture.block.StoolBlock;
import com.starfish_studios.another_furniture.block.TallStoolBlock;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AnotherFurnitureCompat {
    public static final List<DeferredHolder<Block, ? extends Block>> BLOCKS = new ArrayList<DeferredHolder<Block, ? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "another_furniture_" + color.getSerializedName();
        BLOCKS.add(DyenamicRegistry.registerBlock(prefix + "_lamp", () -> new LampBlock(color.getAnalogue(), BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(2.0f, 3.0f).sound(SoundType.METAL).lightLevel(blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? (Integer)blockState.getValue((Property)ModBlockStateProperties.LEVEL_1_3) * 5 : color.getLightValue())), true));
        BLOCKS.add(DyenamicRegistry.registerBlock(prefix + "_curtain", () -> new CurtainBlock(BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(0.1f).sound(SoundType.WOOL).noOcclusion().lightLevel(state -> color.getLightValue())), true));
        BLOCKS.add(DyenamicRegistry.registerBlock(prefix + "_sofa", () -> new SofaBlock(BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(1.0f, 3.0f).sound(SoundType.WOOD).lightLevel(state -> color.getLightValue())), true));
        BLOCKS.add(DyenamicRegistry.registerBlock(prefix + "_stool", () -> new StoolBlock(BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(1.0f, 3.0f).sound(SoundType.WOOD).lightLevel(state -> color.getLightValue())), true));
        BLOCKS.add(DyenamicRegistry.registerBlock(prefix + "_tall_stool", () -> new TallStoolBlock(BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(1.0f, 3.0f).sound(SoundType.WOOD).lightLevel(state -> color.getLightValue())), true));
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.parse((String)"another_furniture:another_furniture"));
        if (event.getTabKey().equals(key)) {
            BLOCKS.forEach(holder -> event.accept((ItemLike)holder.get()));
        }
    }
}

