/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RequestManageWaystoneModifiersMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RequestManageWaystoneModifiersMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"request_manage_waystone_modifiers"));
    private final BlockPos pos;

    public RequestManageWaystoneModifiersMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(FriendlyByteBuf buf, RequestManageWaystoneModifiersMessage message) {
        buf.writeBlockPos(message.pos);
    }

    public static RequestManageWaystoneModifiersMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        return new RequestManageWaystoneModifiersMessage(pos);
    }

    public static void handle(ServerPlayer player, RequestManageWaystoneModifiersMessage message) {
        BlockPos pos = message.pos;
        if (player.distanceToSqr((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)) > 64.0) {
            return;
        }
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            waystoneBlockEntity.getModifierMenuProvider().ifPresent(menuProvider -> Balm.getNetworking().openGui((Player)player, menuProvider));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

