/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;

public class TestingTools {
    public static <T extends Comparable<T>> BlockState set(BlockState state, Property<T> property, String value) {
        Optional optionalValue = property.getValue(value);
        return optionalValue.map(t -> (BlockState)state.setValue(property, t)).orElse(state);
    }

    public static List<Predicate<ItemStack>> getItemsJson(JsonElement itemObj) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        if (itemObj.isJsonObject()) {
            Predicate<ItemStack> matcher = TestingTools.getMatcher(itemObj.getAsJsonObject());
            if (matcher != null) {
                items.add(matcher);
            }
        } else if (itemObj.isJsonArray()) {
            for (JsonElement element : itemObj.getAsJsonArray()) {
                JsonObject obj = element.getAsJsonObject();
                Predicate<ItemStack> matcher = TestingTools.getMatcher(obj);
                if (matcher == null) continue;
                items.add(matcher);
            }
        } else {
            ErrorHandler.error("Item description is not valid!");
        }
        return items;
    }

    private static Predicate<Integer> getExpressionInteger(String expression, boolean onlyInt) {
        try {
            if (expression.startsWith(">=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i >= amount;
            }
            if (expression.startsWith(">")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i > amount;
            }
            if (expression.startsWith("<=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i <= amount;
            }
            if (expression.startsWith("<")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i < amount;
            }
            if (expression.startsWith("=")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i == amount;
            }
            if (expression.startsWith("!=") || expression.startsWith("<>")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i != amount;
            }
            if (expression.contains("-")) {
                String[] split = StringUtils.split((String)expression, (String)"-");
                int amount1 = Integer.parseInt(split[0]);
                int amount2 = Integer.parseInt(split[1]);
                return i -> i >= amount1 && i <= amount2;
            }
            int amount = Integer.parseInt(expression);
            return i -> i == amount;
        }
        catch (NumberFormatException e) {
            if (onlyInt) {
                ErrorHandler.error("Bad expression '" + expression + "'!");
            }
            return null;
        }
    }

    public static Predicate<Integer> getExpression(JsonElement element) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return i -> i == amount;
            }
            return TestingTools.getExpressionInteger(element.getAsString(), true);
        }
        ErrorHandler.error("Bad expression!");
        return null;
    }

    private static Predicate<CompoundTag> getExpressionOrString(JsonElement element, String tag) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return tagCompound -> tagCompound.getInt(tag) == amount;
            }
            if (element.getAsJsonPrimitive().isBoolean()) {
                boolean v = element.getAsBoolean();
                return tagCompound -> tagCompound.getBoolean(tag) == v;
            }
            String str = element.getAsString();
            Predicate<Integer> predicate = TestingTools.getExpressionInteger(str, false);
            if (predicate == null) {
                return tagCompound -> str.equals(tagCompound.getString(tag));
            }
            return tagCompound -> predicate.test(tagCompound.getInt(tag));
        }
        ErrorHandler.error("Bad expression!");
        return null;
    }

    private static Predicate<ItemStack> getMatcher(String name) {
        ItemStack stack = Tools.parseStack(name);
        if (!stack.isEmpty()) {
            if (name.contains("/") && name.contains("@")) {
                return s -> ItemStack.isSameItem((ItemStack)s, (ItemStack)stack) && ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("/")) {
                return s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack) && ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("@")) {
                return s -> ItemStack.isSameItem((ItemStack)s, (ItemStack)stack);
            }
            return s -> s.getItem() == stack.getItem();
        }
        return null;
    }

    private static Predicate<ItemStack> getMatcher(JsonObject obj) {
        Predicate<Integer> energy;
        List<Predicate<CompoundTag>> nbtMatchers;
        Predicate<ItemStack> finalTest;
        Predicate<Integer> count;
        Predicate<ItemStack> test;
        Item item;
        if (obj.has("empty")) {
            boolean empty = obj.get("empty").getAsBoolean();
            return s -> s.isEmpty() == empty;
        }
        if (obj.has("item")) {
            String name = obj.get("item").getAsString();
            item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)name));
            if (item == null) {
                ErrorHandler.error("Unknown item '" + name + "'!");
                return null;
            }
        } else {
            item = null;
        }
        if (obj.has("damage")) {
            Predicate<Integer> damage = TestingTools.getExpression(obj.get("damage"));
            if (damage == null) {
                return null;
            }
            test = item == null ? s -> damage.test(s.getDamageValue()) : s -> s.getItem() == item && damage.test(s.getDamageValue());
        } else {
            test = item == null ? null : s -> s.getItem() == item;
        }
        if (obj.has("count") && (count = TestingTools.getExpression(obj.get("count"))) != null) {
            if (test == null) {
                test = s -> count.test(s.getCount());
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && count.test(s.getCount());
            }
        }
        if (obj.has("tag")) {
            ResourceLocation tagname = ResourceLocation.parse((String)obj.get("tag").getAsString());
            TagKey key = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagname);
            if (test == null) {
                test = s -> s.is(key);
            } else {
                Predicate<ItemStack> finalTest2 = test;
                test = s -> finalTest2.test((ItemStack)s) && s.is(key);
            }
        }
        if (obj.has("mod")) {
            String mod = obj.get("mod").getAsString();
            if (test == null) {
                test = s -> mod.equals(BuiltInRegistries.ITEM.getKey((Object)s.getItem()).getNamespace());
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && mod.equals(BuiltInRegistries.ITEM.getKey((Object)s.getItem()).getNamespace());
            }
        }
        if (obj.has("nbt") && (nbtMatchers = TestingTools.getNbtMatchers(obj)) != null) {
            if (test == null) {
                test = s -> nbtMatchers.stream().allMatch(p -> {
                    DataComponentPatch patch = s.getComponentsPatch();
                    DataResult result = DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)patch);
                    Tag tag = (Tag)result.getOrThrow();
                    return p.test((CompoundTag)tag);
                });
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && nbtMatchers.stream().allMatch(p -> {
                    DataComponentPatch patch = s.getComponentsPatch();
                    DataResult result = DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)patch);
                    Tag tag = (Tag)result.getOrThrow();
                    return p.test((CompoundTag)tag);
                });
            }
        }
        if (obj.has("energy") && (energy = TestingTools.getExpression(obj.get("energy"))) != null) {
            if (test == null) {
                test = s -> energy.test(TestingTools.getEnergy(s));
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && energy.test(TestingTools.getEnergy(s));
            }
        }
        if (test == null) {
            ErrorHandler.error("No item description found!");
        }
        return test;
    }

    private static int getEnergy(ItemStack stack) {
        IEnergyStorage capability = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (capability == null) {
            return 0;
        }
        return capability.getEnergyStored();
    }

    public static boolean contains(LevelAccessor world, BlockPos pos, @Nullable Direction side, @Nonnull List<Predicate<ItemStack>> matchers) {
        IItemHandler h;
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity != null && (h = (IItemHandler)serverLevel.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side)) != null) {
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack stack = h.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                for (Predicate<ItemStack> matcher : matchers) {
                    if (!matcher.test(stack)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static int getEnergy(LevelAccessor world, BlockPos pos, @Nullable Direction side) {
        IEnergyStorage s;
        if (!(world instanceof ServerLevel)) {
            return 0;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity != null && (s = (IEnergyStorage)serverLevel.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)side)) != null) {
            return s.getEnergyStored();
        }
        return 0;
    }

    private static List<Predicate<CompoundTag>> getNbtMatchers(JsonObject obj) {
        JsonArray nbtArray = obj.getAsJsonArray("nbt");
        return TestingTools.getNbtMatchers(nbtArray);
    }

    private static List<Predicate<CompoundTag>> getNbtMatchers(JsonArray nbtArray) {
        ArrayList<Predicate<CompoundTag>> nbtMatchers = new ArrayList<Predicate<CompoundTag>>();
        for (JsonElement element : nbtArray) {
            JsonObject o = element.getAsJsonObject();
            String tag = o.get("tag").getAsString();
            if (o.has("contains")) {
                List<Predicate<CompoundTag>> subMatchers = TestingTools.getNbtMatchers(o.getAsJsonArray("contains"));
                nbtMatchers.add(tagCompound -> {
                    if (tagCompound != null) {
                        ListTag list = tagCompound.getList(tag, 10);
                        for (Tag base : list) {
                            for (Predicate matcher : subMatchers) {
                                if (!matcher.test((CompoundTag)base)) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                });
                continue;
            }
            Predicate<CompoundTag> nbt = TestingTools.getExpressionOrString(o.get("value"), tag);
            if (nbt == null) continue;
            nbtMatchers.add(nbt);
        }
        return nbtMatchers;
    }

    public static List<Predicate<ItemStack>> getItems(List<String> itemNames) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Predicate<ItemStack> matcher;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                matcher = TestingTools.getMatcher(name);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                matcher = TestingTools.getMatcher(obj);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            ErrorHandler.error("Item description '" + json + "' is not valid!");
        }
        return items;
    }

    public static boolean isSlimeChunk(ChunkPos cp, LevelAccessor world) {
        long seed = 0L;
        if (world instanceof WorldGenLevel) {
            WorldGenLevel level = (WorldGenLevel)world;
            seed = level.getSeed();
        }
        return WorldgenRandom.seedSlimeChunk((int)cp.x, (int)cp.z, (long)seed, (long)987234911L).nextInt(10) == 0;
    }

    public static boolean isFakePlayer(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return true;
        }
        PlayerList playerList = entity.getCommandSenderWorld().getServer().getPlayerList();
        ServerPlayer playerByUUID = playerList.getPlayer(((Player)entity).getGameProfile().getId());
        if (playerByUUID == null) {
            return true;
        }
        return entity != playerByUUID;
    }

    public static boolean isRealPlayer(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        return !TestingTools.isFakePlayer(entity);
    }

    public static void warn(String message) {
        InControl.setup.getLogger().warn(message);
    }

    public static boolean isChunkInvalid(LevelAccessor world, BlockPos pos) {
        LevelChunk chunk = world.getChunkSource().getChunkNow(pos.getX() >> 4, pos.getZ() >> 4);
        return chunk == null || !chunk.getPersistedStatus().isOrAfter(ChunkStatus.FULL);
    }

    @Nullable
    public static NumberResult parseNumberCheck(JsonElement element) {
        if (!element.isJsonObject()) {
            ErrorHandler.error("Number check needs to be an object!");
            return null;
        }
        JsonObject object = element.getAsJsonObject();
        if (!object.has("name")) {
            ErrorHandler.error("Number check needs to have a 'name' field!");
            return null;
        }
        if (!object.has("expression")) {
            ErrorHandler.error("Number check needs to have a 'expression' field!");
            return null;
        }
        String number = object.get("name").getAsString();
        String expression = object.get("expression").getAsString();
        Predicate<Integer> test = Tools.parseExpression(expression);
        if (test == null) {
            return null;
        }
        return new NumberResult(number, test);
    }

    public record NumberResult(String number, Predicate<Integer> test) {
    }
}

