/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.recipe;

import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.util.TagUtil;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class DrawerlessWoodIngredient
implements ICustomIngredient {
    public static final MapCodec<DrawerlessWoodIngredient> CODEC = MapCodec.unit(DrawerlessWoodIngredient::new);
    public static Holder<IngredientType<?>> TYPE;
    public static final ResourceLocation NAME;
    private Set<Item> woodless;

    public Stream<ItemStack> getItems() {
        return this.getWoods().stream().map(ItemStack::new);
    }

    public boolean test(ItemStack stack) {
        return this.getWoods().contains(stack.getItem());
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)TYPE.value();
    }

    private Set<Item> getWoods() {
        if (this.woodless == null) {
            this.woodless = TagUtil.getAllEntries((Registry)BuiltInRegistries.ITEM, (TagKey)ItemTags.PLANKS).stream().filter(item -> !BuiltInRegistries.ITEM.getKey(item).getNamespace().equalsIgnoreCase("minecraft")).collect(Collectors.toSet());
            this.woodless.add(Items.OAK_PLANKS);
        }
        return this.woodless;
    }

    static {
        NAME = Utils.resourceLocation("functionalstorage", "woodless");
    }
}

