/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.wispforest.owo.ui.util.Delta;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import rearth.oracle.Oracle;
import rearth.oracle.SemanticSearch;
import rearth.oracle.progress.AdvancementProgressValidator;
import rearth.oracle.ui.OracleScreen;
import rearth.oracle.ui.SearchScreen;
import rearth.oracle.util.MarkdownParser;

public final class OracleClient {
    public static final KeyMapping ORACLE_WIKI = new KeyMapping("key.oracle_index.open", 72, "key.categories.oracle");
    public static final KeyMapping ORACLE_SEARCH = new KeyMapping("key.oracle_index.search", -1, "key.categories.oracle");
    public static final Set<String> LOADED_BOOKS = new HashSet<String>();
    public static final HashMap<ResourceLocation, BookItemLink> ITEM_LINKS = new HashMap();
    public static final HashMap<String, Tuple<String, String>> UNLOCK_CRITERIONS = new HashMap();
    public static ItemStack tooltipStack;
    public static float openEntryProgress;
    private static SemanticSearch searchInstance;

    public static void init() {
        Oracle.LOGGER.info("Hello from the Oracle Wiki Client!");
        KeyMappingRegistry.register((KeyMapping)ORACLE_WIKI);
        KeyMappingRegistry.register((KeyMapping)ORACLE_SEARCH);
        AdvancementProgressValidator.register();
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (ORACLE_WIKI.consumeClick()) {
                if (Screen.hasControlDown()) {
                    Oracle.LOGGER.info("Opening Oracle Search...");
                    client.setScreen((Screen)new SearchScreen(client.screen));
                    return;
                }
                Oracle.LOGGER.info("Opening Oracle Wiki...");
                client.setScreen((Screen)new OracleScreen(client.screen));
            }
            if (ORACLE_SEARCH.consumeClick()) {
                Oracle.LOGGER.info("Opening Oracle Search...");
                client.setScreen((Screen)new SearchScreen(client.screen));
            }
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(client -> {
            Oracle.LOGGER.info("Indexing entry items...");
            OracleClient.findAllResourceEntries();
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (Screen.hasAltDown()) {
                return;
            }
            openEntryProgress += Delta.compute((float)openEntryProgress, (float)0.0f, (float)0.13f);
        });
    }

    public static void openScreen(@Nullable String bookId, @Nullable ResourceLocation entryId, @Nullable Screen parent) {
        if (bookId != null) {
            OracleScreen.activeBook = bookId;
        }
        if (entryId != null) {
            OracleScreen.activeEntry = entryId;
        }
        Minecraft.getInstance().setScreen((Screen)new OracleScreen(parent));
    }

    private static void findAllResourceEntries() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        Map resources = resourceManager.listResources("books", path -> path.getPath().endsWith(".mdx"));
        LOADED_BOOKS.clear();
        for (ResourceLocation resourceId : resources.keySet()) {
            String entryFileName;
            String[] segments;
            String modId;
            String purePath = resourceId.getPath().replaceFirst("books/", "");
            String entryPath = purePath.replaceFirst((modId = (segments = purePath.split("/"))[0]) + "/", "");
            String entryDirectory = entryPath.replace(entryFileName = segments[segments.length - 1], "");
            if (entryDirectory.startsWith(".translated")) continue;
            try {
                String unlockText;
                String[] unlockParts;
                String fileContent = new String(((Resource)resources.get(resourceId)).open().readAllBytes(), StandardCharsets.UTF_8);
                Map<String, String> fileComponents = MarkdownParser.parseFrontmatter(fileContent);
                if (fileComponents.containsKey("related_items")) {
                    String[] itemStrings;
                    String baseString = fileComponents.get("related_items").replace("[", "").replace("]", "");
                    for (String itemString : itemStrings = baseString.split(", ")) {
                        ResourceLocation itemId = ResourceLocation.parse((String)itemString);
                        BookItemLink linkData = new BookItemLink(resourceId, fileComponents.getOrDefault("title", "missing"), modId);
                        ITEM_LINKS.put(itemId, linkData);
                    }
                }
                if (fileComponents.containsKey("unlock") && (unlockParts = (unlockText = fileComponents.get("unlock")).split(":", 2)).length == 2) {
                    String unlockType = unlockParts[0];
                    String unlockContent = unlockParts[1];
                    UNLOCK_CRITERIONS.put(resourceId.getPath(), (Tuple<String, String>)new Tuple((Object)unlockType, (Object)unlockContent));
                }
            }
            catch (IOException e) {
                Oracle.LOGGER.error("Unable to load book with id: " + String.valueOf(resourceId));
                throw new RuntimeException(e);
            }
            LOADED_BOOKS.add(modId);
        }
    }

    public static SemanticSearch getOrCreateSearch() {
        if (searchInstance == null) {
            searchInstance = new SemanticSearch();
        }
        return searchInstance;
    }

    public static String getActiveLangCode() {
        return Minecraft.getInstance().getLanguageManager().getSelected();
    }

    public static Optional<ResourceLocation> getTranslatedPath(ResourceLocation identifier, String bookId) {
        ResourceLocation translatedPath;
        String languageCode = OracleClient.getActiveLangCode();
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        if (!languageCode.startsWith("en_") && resourceManager.getResource(translatedPath = ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)identifier.getPath().replace("books/" + bookId, "books/" + bookId + "/.translated/" + languageCode))).isPresent()) {
            return Optional.of(translatedPath);
        }
        return Optional.empty();
    }

    static {
        openEntryProgress = 0.0f;
    }

    public record BookItemLink(ResourceLocation linkTarget, String entryName, String bookId) {
    }
}

