/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.util;

import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemUtil {
    public static final Hash.Strategy<ItemStack> COUNT_INSENSITIVE_HASH_STRATEGY = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            int itemHash = o.getItem().hashCode();
            itemHash ^= o.getComponents().hashCode() + -1640531527 + (itemHash << 6) + (itemHash >> 2);
            return itemHash;
        }

        public boolean equals(ItemStack a, ItemStack b) {
            return a == null && b == null || a != null && b != null && ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
        }
    };

    public static void drop(ServerLevel level, ItemStack stack, Vec3 pos) {
        if (stack.isEmpty()) {
            return;
        }
        int maxSize = stack.getMaxStackSize();
        while (!stack.isEmpty()) {
            level.addFreshEntity((Entity)new ItemEntity((Level)level, pos.x, pos.y, pos.z, stack.copyWithCount(Math.min(maxSize, stack.getCount()))));
            stack.shrink(maxSize);
        }
    }

    public static <R extends SpecialSingleInputRecipe> void processItems(ServerLevel level, List<ItemEntity> itemEntities, int limit, RecipeType<R> type, Function<R, List<ItemStack>> outputExtractor) {
        if (itemEntities.isEmpty()) {
            return;
        }
        RecipeHolder recipe = null;
        int itemsProcessed = 0;
        ObjectOpenCustomHashSet results = new ObjectOpenCustomHashSet(8, COUNT_INSENSITIVE_HASH_STRATEGY);
        for (ItemEntity entity : itemEntities) {
            if (itemsProcessed >= limit) break;
            ItemStack stack = entity.getItem();
            recipe = level.getRecipeManager().getRecipeFor(type, (RecipeInput)new SingleRecipeInput(stack), (Level)level, recipe).orElse(null);
            if (recipe == null) continue;
            while (!stack.isEmpty() && itemsProcessed < limit) {
                List<ItemStack> outputs = outputExtractor.apply((SpecialSingleInputRecipe)recipe.value());
                stack.shrink(1);
                ++itemsProcessed;
                for (ItemStack result : outputs) {
                    ItemStack existing = (ItemStack)results.get((Object)result);
                    if (existing != null) {
                        existing.setCount(result.getCount() + existing.getCount());
                        continue;
                    }
                    results.add((Object)result);
                }
            }
            for (ItemStack result : results) {
                ItemUtil.drop(level, result, entity.position());
            }
            results.clear();
        }
    }
}

