/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.cut;

import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.SawmillRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class MekanismSawmillProcessor
extends Processor<SingleRecipeInput, SawmillRecipe> {
    public MekanismSawmillProcessor(MinecraftServer server) {
        super(server, (RecipeType)MekanismRecipeTypes.TYPE_SAWING.get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.cutRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(SawmillRecipe recipe) {
        SizedIngredient sized = recipe.getInput().ingredient();
        if (sized.count() != 1) {
            return null;
        }
        Ingredient ingredient = sized.ingredient();
        if (ingredient.isEmpty()) {
            return null;
        }
        return ingredient;
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends SawmillRecipe> recipeHolder, Ingredient ingredient) {
        RecipeWrapper.Cut wrapper = new RecipeWrapper.Cut(recipeHolder.id(), ingredient);
        SawmillRecipe recipe = (SawmillRecipe)recipeHolder.value();
        for (ItemStack output : recipe.getMainOutputDefinition()) {
            wrapper = wrapper.withItems(output.copy());
        }
        for (ItemStack output : recipe.getSecondaryOutputDefinition()) {
            wrapper = wrapper.withItems(output.copy(), (float)recipe.getSecondaryChance());
        }
        return wrapper.asHolder();
    }
}

