/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.client.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.qther.ars_unification.client.emi.EmiArsUnificationPlugin;
import dev.qther.ars_unification.recipe.PressRecipe;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class EmiPressRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final PressRecipe recipe;

    public EmiPressRecipe(ResourceLocation id, PressRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
    }

    public EmiPressRecipe(RecipeHolder<PressRecipe> holder) {
        this(holder.id(), (PressRecipe)holder.value());
    }

    public EmiRecipeCategory getCategory() {
        return EmiArsUnificationPlugin.PRESS_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((Ingredient)this.recipe.input()));
    }

    public List<EmiStack> getOutputs() {
        return this.recipe.outputs().stream().map(PressRecipe.PressOutput::stack).map(EmiStack::of).toList();
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 86;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.input()), 4, this.getDisplayHeight() / 2 - 10);
        widgets.addFillingArrow(24, this.getDisplayHeight() / 2 - 10, 2000);
        for (int i = this.recipe.outputs().size() - 1; i >= 0; --i) {
            PressRecipe.PressOutput output = this.recipe.outputs().get(i);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)output.stack()).setChance(output.chance()), 53, 5 + 16 * i).recipeContext((EmiRecipe)this);
            widgets.addText((Component)Component.literal((String)(Math.round(100.0f * output.chance() - 0.5f) + "%")), 97, 11 + 17 * i, 10, false);
            if (output.maxRange() <= 1) continue;
            widgets.addText((Component)Component.literal((String)("1-" + output.maxRange())), 75, 11 + 17 * i, 10, false);
        }
    }
}

