/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.utils;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.codec.ZCrystal;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public class GlowHandler {
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] FIRE = new float[]{1.0f, 0.3f, 0.2f, 1.0f};
    private static final float[] WATER = new float[]{0.3f, 0.6f, 1.0f, 1.0f};
    private static final float[] GRASS = new float[]{0.3f, 1.0f, 0.4f, 1.0f};
    private static final float[] ELECTRIC = new float[]{1.0f, 1.0f, 0.3f, 1.0f};
    private static final float[] ICE = new float[]{0.6f, 0.9f, 1.0f, 1.0f};
    private static final float[] FIGHTING = new float[]{0.8f, 0.3f, 0.2f, 1.0f};
    private static final float[] POISON = new float[]{0.7f, 0.3f, 0.8f, 1.0f};
    private static final float[] GROUND = new float[]{0.8f, 0.65f, 0.4f, 1.0f};
    private static final float[] FLYING = new float[]{0.7f, 0.7f, 1.0f, 1.0f};
    private static final float[] PSYCHIC = new float[]{1.0f, 0.4f, 0.7f, 1.0f};
    private static final float[] BUG = new float[]{0.6f, 0.8f, 0.2f, 1.0f};
    private static final float[] ROCK = new float[]{0.7f, 0.6f, 0.4f, 1.0f};
    private static final float[] GHOST = new float[]{0.6f, 0.5f, 0.9f, 1.0f};
    private static final float[] DRAGON = new float[]{0.5f, 0.4f, 1.0f, 1.0f};
    private static final float[] DARK = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
    private static final float[] STEEL = new float[]{0.7f, 0.75f, 0.8f, 1.0f};
    private static final float[] FAIRY = new float[]{1.0f, 0.6f, 0.9f, 1.0f};
    private static final float[] NORMAL = new float[]{0.9f, 0.9f, 0.9f, 1.0f};

    public static void applyDynamaxGlow(@Nullable PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            return;
        }
        Level level = pokemonEntity.level();
        if (level instanceof ServerLevel) {
            ChatFormatting teamColour;
            String teamName;
            ServerLevel serverLevel = (ServerLevel)level;
            pokemonEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, false, false));
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            if (pokemonEntity.getPokemon().getSpecies().getName().equalsIgnoreCase("calyrex")) {
                teamName = "glow_dynamax_blue";
                teamColour = ChatFormatting.BLUE;
            } else {
                teamName = "glow_dynamax_red";
                teamColour = ChatFormatting.RED;
            }
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setColor(teamColour);
            }
            scoreboard.addPlayerToTeam(pokemonEntity.getScoreboardName(), team);
        }
    }

    public static void applyTeraGlow(PokemonEntity pokemon, String aspect) {
        Level level = pokemon.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            pokemon.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, false, false));
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            String teamName = "glow_tera_" + pokemon.getPokemon().getTeraType().showdownId();
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            ChatFormatting color = GlowHandler.getFormattingForColor(aspect);
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setColor(color);
            }
            scoreboard.addPlayerToTeam(pokemon.getScoreboardName(), team);
        }
    }

    public static void applyZGlow(PokemonEntity pokemon, ZCrystal zCrystal) {
        Level level = pokemon.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            pokemon.addEffect(new MobEffectInstance(MobEffects.GLOWING, 140, 0, false, false));
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            String teamName = "glow_type_" + zCrystal.color().toLowerCase(Locale.ROOT);
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            ChatFormatting color = GlowHandler.getGlowForColor(zCrystal.color());
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setColor(color);
            }
            scoreboard.addPlayerToTeam(pokemon.getScoreboardName(), team);
        }
    }

    private static ChatFormatting getFormattingForColor(String color) {
        return switch (color) {
            case "red" -> ChatFormatting.RED;
            case "blue" -> ChatFormatting.BLUE;
            case "green" -> ChatFormatting.GREEN;
            case "yellow" -> ChatFormatting.YELLOW;
            case "brown" -> ChatFormatting.DARK_RED;
            case "light_blue" -> ChatFormatting.AQUA;
            case "purple" -> ChatFormatting.DARK_BLUE;
            case "magenta" -> ChatFormatting.LIGHT_PURPLE;
            case "black" -> ChatFormatting.BLACK;
            case "gray" -> ChatFormatting.GRAY;
            case "lime" -> ChatFormatting.DARK_GREEN;
            case "indigo" -> ChatFormatting.DARK_PURPLE;
            case "tan" -> ChatFormatting.DARK_GRAY;
            default -> ChatFormatting.WHITE;
        };
    }

    private static ChatFormatting getGlowForColor(String color) {
        if (color == null) {
            return ChatFormatting.WHITE;
        }
        return switch (color.toLowerCase()) {
            case "black" -> ChatFormatting.BLACK;
            case "dark_blue" -> ChatFormatting.DARK_BLUE;
            case "dark_green" -> ChatFormatting.DARK_GREEN;
            case "dark_aqua" -> ChatFormatting.DARK_AQUA;
            case "dark_red" -> ChatFormatting.DARK_RED;
            case "dark_purple" -> ChatFormatting.DARK_PURPLE;
            case "gold" -> ChatFormatting.GOLD;
            case "gray" -> ChatFormatting.GRAY;
            case "dark_gray" -> ChatFormatting.DARK_GRAY;
            case "blue" -> ChatFormatting.BLUE;
            case "green" -> ChatFormatting.GREEN;
            case "aqua" -> ChatFormatting.AQUA;
            case "red" -> ChatFormatting.RED;
            case "light_purple" -> ChatFormatting.LIGHT_PURPLE;
            case "yellow" -> ChatFormatting.YELLOW;
            default -> ChatFormatting.WHITE;
        };
    }

    public static float[] getTeraColor(String teraId) {
        if (teraId == null) {
            return WHITE;
        }
        return switch (teraId) {
            case "msd:tera_fire" -> FIRE;
            case "msd:tera_water" -> WATER;
            case "msd:tera_grass" -> GRASS;
            case "msd:tera_electric" -> ELECTRIC;
            case "msd:tera_ice" -> ICE;
            case "msd:tera_fighting" -> FIGHTING;
            case "msd:tera_poison" -> POISON;
            case "msd:tera_ground" -> GROUND;
            case "msd:tera_flying" -> FLYING;
            case "msd:tera_psychic" -> PSYCHIC;
            case "msd:tera_bug" -> BUG;
            case "msd:tera_rock" -> ROCK;
            case "msd:tera_ghost" -> GHOST;
            case "msd:tera_dragon" -> DRAGON;
            case "msd:tera_dark" -> DARK;
            case "msd:tera_steel" -> STEEL;
            case "msd:tera_fairy" -> FAIRY;
            case "msd:tera_normal" -> NORMAL;
            default -> WHITE;
        };
    }
}

