/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render.layerEntities;

import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.sizer.LayerCodec;
import com.github.yajatkaul.mega_showdown.render.LayerDataLoader;
import com.github.yajatkaul.mega_showdown.render.layerEntities.LayerEntity;
import com.github.yajatkaul.mega_showdown.render.layerEntities.states.DmaxHatState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class DynamaxCloudsLayer
extends LayerEntity {
    private final ResourceLocation poserId = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"dmax_clouds");
    private final Set<String> aspects = new HashSet<String>();

    public DynamaxCloudsLayer() {
        super(new DmaxHatState());
    }

    @Override
    public void render(RenderContext context, PokemonClientDelegate clientDelegate, PokemonEntity entity, Pokemon pokemon, float entityYaw, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render(context, clientDelegate, entity, pokemon, entityYaw, poseStack, buffer, packedLight);
        this.state.setCurrentAspects(this.aspects);
        Map locatorStates = clientDelegate.getLocatorStates();
        MatrixWrapper headLocator = (MatrixWrapper)locatorStates.get("head");
        if (headLocator == null) {
            return;
        }
        PosableModel model = VaryingModelRepository.INSTANCE.getPoser(this.poserId, this.state);
        model.context = context;
        ResourceLocation texture = VaryingModelRepository.INSTANCE.getTexture(this.poserId, this.state);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        model.setBufferProvider(buffer);
        this.state.setCurrentModel(model);
        context.put(RenderContext.Companion.getASPECTS(), this.aspects);
        context.put(RenderContext.Companion.getTEXTURE(), (Object)texture);
        context.put(RenderContext.Companion.getSPECIES(), (Object)this.poserId);
        context.put(RenderContext.Companion.getPOSABLE_STATE(), (Object)this.state);
        LayerCodec.Settings settings = LayerDataLoader.getSettings(pokemon, "msd:dmax");
        poseStack.pushPose();
        poseStack.mulPose(headLocator.getMatrix());
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(0.08, 0.0, 0.0);
        if (settings != null) {
            List<Float> translate = settings.translate();
            poseStack.translate(translate.get(0).floatValue(), translate.get(1).floatValue(), translate.get(2).floatValue());
        }
        if (settings != null) {
            List<Float> scale = settings.scale();
            poseStack.scale(scale.get(0).floatValue(), scale.get(1).floatValue(), scale.get(2).floatValue());
        }
        model.applyAnimations(null, this.state, 0.0f, 0.0f, this.ticks, 0.0f, 0.0f);
        model.render(context, poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        model.withLayerContext(buffer, this.state, VaryingModelRepository.INSTANCE.getLayers(this.poserId, this.state), () -> {
            model.render(context, poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            return Unit.INSTANCE;
        });
        model.setDefault();
        poseStack.popPose();
    }
}

