/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render;

import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.render.renderTypes.MSDRenderTypes;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class TeraMapLoader
implements ResourceManagerReloadListener {
    public static final HashMap<String, String> REGISTRY = new HashMap();
    private static final String DIRECTORY = "mega_showdown/tera_map";

    public static void load() {
        ResourceManager rm = Minecraft.getInstance().getResourceManager();
        REGISTRY.clear();
        Set resources = rm.listResources(DIRECTORY, path -> path.getPath().endsWith(".json")).keySet();
        for (ResourceLocation id : resources) {
            try {
                InputStream stream = ((Resource)rm.getResource(id).get()).open();
                try {
                    TeraMap codec = (TeraMap)TeraMap.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new InputStreamReader(stream))).result().orElseThrow();
                    REGISTRY.putAll(codec.colorMap);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.error("Failed loading tera map JSON: {}", (Object)id, (Object)e);
            }
        }
        MegaShowdown.LOGGER.info("Loaded {} custom tera map", (Object)REGISTRY.size());
    }

    @NotNull
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        TeraMapLoader.load();
        return super.reload(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
    }

    @NotNull
    public String getName() {
        return "mega_showdown";
    }

    public static ShaderInstance getColorShaderMap(String color) {
        return switch (color) {
            case "red" -> MSDRenderTypes.teraFire;
            case "blue" -> MSDRenderTypes.teraWater;
            case "green" -> MSDRenderTypes.teraGrass;
            case "yellow" -> MSDRenderTypes.teraElectric;
            case "brown" -> MSDRenderTypes.teraGround;
            case "light_blue" -> MSDRenderTypes.teraFlying;
            case "purple" -> MSDRenderTypes.teraDragon;
            case "pink" -> MSDRenderTypes.teraFairy;
            case "black" -> MSDRenderTypes.teraDark;
            case "gray" -> MSDRenderTypes.teraSteel;
            case "light_grey" -> MSDRenderTypes.teraIce;
            case "orange" -> MSDRenderTypes.teraFighting;
            case "lime" -> MSDRenderTypes.teraBug;
            case "teal" -> MSDRenderTypes.teraPoison;
            case "indigo" -> MSDRenderTypes.teraGhost;
            case "magenta" -> MSDRenderTypes.teraPsychic;
            case "tan" -> MSDRenderTypes.teraRock;
            case "navy" -> MSDRenderTypes.teraNormal;
            case "white" -> MSDRenderTypes.teraStellar;
            default -> {
                MegaShowdown.LOGGER.error("Unknown tera shader color '{}'", (Object)color);
                yield MSDRenderTypes.teraStellar;
            }
        };
    }

    public record TeraMap(Map<String, String> colorMap) {
        public static Codec<TeraMap> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("aspectShaderMap").forGetter(TeraMap::colorMap)).apply((Applicative)instance, TeraMap::new));
    }
}

