/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.codec.sizer.LayerCodec;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class LayerDataLoader
implements ResourceManagerReloadListener {
    private static final String DIRECTORY = "msd_sizer";
    public static final HashMap<String, SizerRegStruct> LAYER_REGISTRY = new HashMap();

    public static LayerCodec.Settings getSettings(Pokemon pokemon, String aspect) {
        String name = pokemon.getSpecies().resourceIdentifier.getPath();
        String formName = pokemon.getForm().getName();
        SizerRegStruct reg = LAYER_REGISTRY.get(name);
        if (reg == null) {
            return null;
        }
        return reg.getSettings(formName, aspect);
    }

    public static void load() {
        ResourceManager rm = Minecraft.getInstance().getResourceManager();
        LAYER_REGISTRY.clear();
        Set resources = rm.listResources(DIRECTORY, path -> path.getPath().endsWith(".json")).keySet();
        for (ResourceLocation id : resources) {
            try {
                InputStream stream = ((Resource)rm.getResource(id).get()).open();
                try {
                    LayerCodec codec = (LayerCodec)LayerCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new InputStreamReader(stream))).result().orElseThrow();
                    LAYER_REGISTRY.putIfAbsent(codec.pokemon(), new SizerRegStruct());
                    SizerRegStruct sizerRegStruct = LAYER_REGISTRY.get(codec.pokemon());
                    for (String form : codec.size_config().keySet()) {
                        for (Map.Entry<String, LayerCodec.Settings> aspectSetting : codec.size_config().get(form).entrySet()) {
                            sizerRegStruct.addForm(form, aspectSetting.getKey(), aspectSetting.getValue());
                        }
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.error("Failed loading layer JSON: {}", (Object)id, (Object)e);
            }
        }
        MegaShowdown.LOGGER.info("Loaded {} custom layer data", (Object)LAYER_REGISTRY.size());
    }

    @NotNull
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        LayerDataLoader.load();
        return super.reload(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
    }

    @NotNull
    public String getName() {
        return "mega_showdown";
    }

    public static class SizerRegStruct {
        private final HashMap<String, HashMap<String, LayerCodec.Settings>> settingsHashMap = new HashMap();

        public void addForm(String formName, String aspect, LayerCodec.Settings settings) {
            HashMap<String, LayerCodec.Settings> map = this.settingsHashMap.getOrDefault(formName, new HashMap());
            map.put(aspect, settings);
            this.settingsHashMap.putIfAbsent(formName, map);
        }

        public LayerCodec.Settings getSettings(String formName, String aspect) {
            return (LayerCodec.Settings)this.settingsHashMap.getOrDefault(formName, new HashMap()).get(aspect);
        }
    }
}

