/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render;

import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.codec.item.ItemRenderingCodec;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ItemRenderingLoader
implements ResourceManagerReloadListener {
    public static final HashMap<ResourceLocation, ItemRenderingCodec> REGISTRY = new HashMap();
    private static final String DIRECTORY = "item_rendering";

    public static void load() {
        ResourceManager rm = Minecraft.getInstance().getResourceManager();
        REGISTRY.clear();
        Set resources = rm.listResources(DIRECTORY, path -> path.getPath().endsWith(".json")).keySet();
        for (ResourceLocation id : resources) {
            try {
                InputStream stream = ((Resource)rm.getResource(id).get()).open();
                try {
                    ItemRenderingCodec codec = (ItemRenderingCodec)ItemRenderingCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new InputStreamReader(stream))).result().orElseThrow();
                    REGISTRY.put(codec.itemId(), codec);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.error("Failed loading item_rendering JSON: {}", (Object)id, (Object)e);
            }
        }
        MegaShowdown.LOGGER.info("Loaded {} custom rendering entries", (Object)REGISTRY.size());
    }

    @NotNull
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        ItemRenderingLoader.load();
        return super.reload(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
    }

    @NotNull
    public String getName() {
        return "mega_showdown";
    }
}

