/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.neoforge.datapack.showdown;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownService;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.utils.datapack.NewMove;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class Moves
implements DataRegistry {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"mega_showdown/showdown/moves");
    private static final SimpleObservable<Moves> OBSERVABLE = new SimpleObservable();
    public static final Moves INSTANCE = new Moves();
    private final Map<String, String> moveScripts = new HashMap<String, String>();
    Gson gson = new Gson();

    private Moves() {
        OBSERVABLE.subscribe(Priority.NORMAL, this::movesLoad);
    }

    public void movesLoad(Moves move) {
        Cobblemon.INSTANCE.getShowdownThread().queue(showdownService -> {
            if (showdownService instanceof GraalShowdownService) {
                GraalShowdownService service = (GraalShowdownService)showdownService;
                Value receiveMoveDataFn = service.context.getBindings("js").getMember("receiveMoveData");
                for (Map.Entry<String, String> entry : INSTANCE.getMoveScripts().entrySet()) {
                    String moveId = entry.getKey();
                    String js = entry.getValue().replace("\n", " ");
                    JsonObject moveData = (JsonObject)this.gson.fromJson(receiveMoveDataFn.execute(new Object[]{moveId, js}).asString(), JsonObject.class);
                    MoveTemplate newMove = NewMove.INSTANCE.createMoveTemplate(moveData, moveId);
                    NewMove.INSTANCE.register(newMove);
                }
            }
            return Unit.INSTANCE;
        });
    }

    public Map<String, String> getMoveScripts() {
        return this.moveScripts;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public PackType getType() {
        return PackType.SERVER_DATA;
    }

    @NotNull
    public SimpleObservable<? extends DataRegistry> getObservable() {
        return OBSERVABLE;
    }

    public void reload(@NotNull ResourceManager resourceManager) {
        this.moveScripts.clear();
        resourceManager.listResources("mega_showdown/showdown/moves", path -> path.getPath().endsWith(".js")).forEach((id, resource) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
                String js = reader.lines().collect(Collectors.joining("\n"));
                String moveId = new File(id.getPath()).getName().replace(".js", "");
                this.moveScripts.put(moveId, js);
            }
            catch (IOException e) {
                MegaShowdown.LOGGER.error("Failed to load move script: {} {}", id, (Object)e);
            }
        });
        OBSERVABLE.emit((Object[])new Moves[]{this});
    }

    public void sync(@NotNull ServerPlayer serverPlayer) {
    }
}

