/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.mixin.battle;

import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleGimmickMove;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import java.util.List;
import kotlin.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MoveActionResponse.class}, remap=false)
public class MoveActionResponseMixin {
    @Shadow
    private String moveName;
    @Shadow
    private String targetPnx;
    @Shadow
    private String gimmickID;

    @Overwrite
    public boolean isValid(ActiveBattlePokemon activeBattlePokemon, ShowdownMoveset showdownMoveSet, boolean forceSwitch) {
        boolean validGimmickMove;
        if (forceSwitch || showdownMoveSet == null) {
            return false;
        }
        InBattleMove move = showdownMoveSet.getMoves().stream().filter(m -> m.getId().equals(this.moveName)).findFirst().orElse(null);
        if (move == null) {
            return false;
        }
        InBattleGimmickMove gimmickMove = move.getGimmickMove();
        boolean bl = validGimmickMove = gimmickMove != null && !gimmickMove.getDisabled();
        if (!validGimmickMove && !move.canBeUsed()) {
            return false;
        }
        List availableTargets = this.gimmickID != null && validGimmickMove && !this.gimmickID.equalsIgnoreCase("mega") && !this.gimmickID.equalsIgnoreCase("terastal") ? (List)gimmickMove.getTarget().getTargetList().invoke((Object)activeBattlePokemon) : (List)move.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
        if (availableTargets == null || availableTargets.isEmpty()) {
            return true;
        }
        if (this.targetPnx == null) {
            return false;
        }
        Pair targetPair = activeBattlePokemon.getActor().getBattle().getActorAndActiveSlotFromPNX(this.targetPnx);
        return availableTargets.contains(targetPair.getSecond());
    }
}

