/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.tera;

import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.item.MegaShowdownItems;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingItem;
import com.github.yajatkaul.mega_showdown.utils.ParticlesList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeraShard
extends PokemonSelectingItem {
    private final TeraType teraType;

    public TeraShard(Item.Properties arg, TeraType teraType) {
        super(arg);
        this.teraType = teraType;
    }

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack itemStack, @NotNull Pokemon pokemon) {
        int required_shards = MegaShowdownConfig.teraShardRequired;
        if (itemStack.getCount() >= required_shards) {
            itemStack.consume(required_shards, (LivingEntity)player);
            if (itemStack.getItem() == MegaShowdownItems.STELLAR_TERA_SHARD.get()) {
                AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "tera/change_tera_stellar");
            }
            if (pokemon.getEntity() != null) {
                ParticlesList.glowParticles.apply(pokemon.getEntity());
            }
            pokemon.setTeraType(this.teraType);
            pokemon.setTeraType(this.teraType);
            AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "tera/change_tera");
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.tera_requirements", (Object[])new Object[]{required_shards}).withColor(0xFF0000), true);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        return !pokemon.getSpecies().getName().equals("Ogerpon") && !pokemon.getSpecies().getName().equals("Terapagos") && pokemon.getTeraType() != this.teraType;
    }
}

