/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingBlockItem;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RotomUnitItem
extends PokemonSelectingBlockItem {
    private static final List<String> rotomAspects = List.of("heat-appliance", "wash-appliance", "mow-appliance", "frost-appliance", "fan-appliance");
    private final String form;

    public RotomUnitItem(Block block, Item.Properties properties, String form) {
        super(block, properties);
        this.form = form;
    }

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer serverPlayer, @NotNull ItemStack itemStack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(itemStack, pokemon)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        Effect.getEffect("mega_showdown:rotom_" + this.form + "_effect").applyEffects(pokemon, List.of(String.format("appliance=%s", this.form)), null);
        itemStack.consume(1, (LivingEntity)serverPlayer);
        AdvancementHelper.grantAdvancement(serverPlayer, "rotom/rotom_form_change");
        return InteractionResultHolder.success((Object)itemStack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        if (!pokemon.getSpecies().getName().equals("Rotom")) return false;
        if (!pokemon.getAspects().stream().noneMatch(rotomAspects::contains)) return false;
        if (pokemon.getPersistentData().contains("form_changing")) return false;
        return true;
    }
}

