/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingItem;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormChangeInteractItem
extends PokemonSelectingItem {
    private final String form_aspect_name;
    private final String form_aspect_apply;
    private final List<String> pokemons;
    private final String effectId;
    private final int consume;
    private final boolean revertable;
    private final String form_aspect_revert;

    public FormChangeInteractItem(Item.Properties properties, String form_aspect_name, String form_aspect_apply, List<String> pokemons, String effectId, int consume, boolean revertable, String form_aspect_revert) {
        super(properties);
        this.form_aspect_name = form_aspect_name;
        this.form_aspect_apply = form_aspect_apply;
        this.form_aspect_revert = form_aspect_revert;
        this.pokemons = pokemons;
        this.effectId = effectId;
        this.consume = consume;
        this.revertable = revertable;
    }

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer serverPlayer, @NotNull ItemStack itemStack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(itemStack, pokemon)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (pokemon.getAspects().contains(this.form_aspect_name) && !this.revertable) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (pokemon.getAspects().contains(this.form_aspect_name)) {
            Effect.getEffect(this.effectId).revertEffects(pokemon, List.of(this.form_aspect_revert), null);
            itemStack.consume(this.consume, (LivingEntity)serverPlayer);
            return InteractionResultHolder.success((Object)itemStack);
        }
        Effect.getEffect(this.effectId).applyEffects(pokemon, List.of(this.form_aspect_apply), null);
        itemStack.consume(this.consume, (LivingEntity)serverPlayer);
        return InteractionResultHolder.success((Object)itemStack);
    }

    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        return this.pokemons.contains(pokemon.getSpecies().getName()) && !pokemon.getPersistentData().contains("form_changing");
    }
}

