/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingBlockItem;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeoxysMeteoridItem
extends PokemonSelectingBlockItem {
    private final List<String> form_apply_order = List.of("normal-forme", "attack-forme", "speed-forme", "defense-forme");
    private final List<List<String>> form_aspect_apply_order = List.of(List.of("meteorite_forme=normal"), List.of("meteorite_forme=attack"), List.of("meteorite_forme=speed"), List.of("meteorite_forme=defense"));

    public DeoxysMeteoridItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        return pokemon.getSpecies().getName().equals("Deoxys") && !pokemon.getPersistentData().contains("form_changing");
    }

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer serverPlayer, @NotNull ItemStack itemStack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(itemStack, pokemon)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        int currentIndex = -1;
        for (int i = 0; i < this.form_apply_order.size(); ++i) {
            String form = this.form_apply_order.get(i);
            boolean hasAspect = pokemon.getAspects().stream().anyMatch(aspect -> aspect.equalsIgnoreCase(form));
            if (!hasAspect) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (currentIndex + 1 > this.form_apply_order.size() - 1) {
            Effect.getEffect("mega_showdown:deoxys_effect").applyEffects(pokemon, this.form_aspect_apply_order.getFirst(), null);
        } else {
            Effect.getEffect("mega_showdown:deoxys_effect").applyEffects(pokemon, this.form_aspect_apply_order.get(currentIndex + 1), null);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }
}

