/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureAssignments;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.datapack.MegaShowdownDatapackRegister;
import com.github.yajatkaul.mega_showdown.gimmick.MegaGimmick;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class MegaShowdownCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msd").then(Commands.literal((String)"hard_reset_mega").executes(MegaShowdownCommands::hard_reset_mega))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(req -> req.hasPermission(4))).executes(MegaShowdownCommands::reload))).then(((LiteralArgumentBuilder)Commands.literal((String)"apply").requires(req -> req.hasPermission(4))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests((cxt, builder) -> {
            builder.suggest("solo_fusion");
            builder.suggest("mega");
            builder.suggest("showdown_item");
            builder.suggest("held_form_change");
            builder.suggest("du_fusion");
            builder.suggest("form_change_interact");
            builder.suggest("form_change_toggle_interact");
            builder.suggest("z_crystal_item");
            return builder.buildFuture();
        }).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"resource_id", (ArgumentType)StringArgumentType.greedyString()).executes(MegaShowdownCommands::applyComponent)).suggests((cxt, builder) -> {
            String type;
            switch (type = StringArgumentType.getString((CommandContext)cxt, (String)"type")) {
                case "solo_fusion": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.SOLO_FUSION_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
                case "mega": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.MEGA_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
                case "held_form_change": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.HELD_ITEM_FORM_CHANGE_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
                case "du_fusion": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.DU_FUSION_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
                case "form_change_interact": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.FORM_CHANGE_INTERACT_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
                case "form_change_toggle_interact": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.FORM_CHANGE_TOGGLE_INTERACT_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
                case "showdown_item": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.SHOWDOWN_ITEM_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
                case "z_crystal_item": {
                    for (ResourceLocation location : MegaShowdownDatapackRegister.Z_CRYSTAL_ITEM_REGISTRY.keySet()) {
                        builder.suggest(String.valueOf(location));
                    }
                    break;
                }
            }
            return builder.buildFuture();
        })))));
    }

    private static int reload(CommandContext<CommandSourceStack> commandSourceStackCommandContext) {
        MegaShowdownConfig.load();
        return 1;
    }

    private static int hard_reset_mega(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        for (Pokemon pokemon : playerPartyStore) {
            boolean hasMega = SpeciesFeatureAssignments.getFeatures((Species)pokemon.getSpecies()).stream().anyMatch(pokemon.getAspects()::contains);
            if (!hasMega) continue;
            MegaGimmick.unmegaEvolve(pokemon);
        }
        return 1;
    }

    private static int applyComponent(CommandContext<CommandSourceStack> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        String resourceId = StringArgumentType.getString(context, (String)"resource_id");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 1;
        }
        ItemStack stack = player.getMainHandItem();
        stack.set(MegaShowdownDataComponents.REGISTRY_TYPE_COMPONENT.get(), (Object)type);
        stack.set(MegaShowdownDataComponents.RESOURCE_LOCATION_COMPONENT.get(), (Object)ResourceLocation.tryParse((String)resourceId));
        return 0;
    }
}

