/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block.block_entity.renderer;

import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.github.yajatkaul.mega_showdown.block.block_entity.MegaStoneStandEntity;
import com.github.yajatkaul.mega_showdown.block.block_entity.renderer.state.MegaStoneStandState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Collections;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MegaStoneStandRenderer
implements BlockEntityRenderer<MegaStoneStandEntity> {
    private final RenderContext context = new RenderContext();
    private final ResourceLocation poserId = ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"mega_stone_stand");

    public MegaStoneStandRenderer(BlockEntityRendererProvider.Context context) {
        this.context.put(RenderContext.Companion.getRENDER_STATE(), (Object)RenderContext.RenderState.BLOCK);
        this.context.put(RenderContext.Companion.getDO_QUIRKS(), (Object)true);
    }

    public void render(MegaStoneStandEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int overlay) {
        Set aspects = Collections.emptySet();
        MegaStoneStandState state = blockEntity.state;
        state.setCurrentAspects(aspects);
        state.updatePartialTicks(tickDelta);
        PosableModel model = VaryingModelRepository.INSTANCE.getPoser(this.poserId, (PosableState)state);
        model.context = this.context;
        ResourceLocation texture = VaryingModelRepository.INSTANCE.getTexture(this.poserId, (PosableState)state);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        model.setBufferProvider(multiBufferSource);
        state.setCurrentModel(model);
        this.context.put(RenderContext.Companion.getASPECTS(), aspects);
        this.context.put(RenderContext.Companion.getTEXTURE(), (Object)texture);
        this.context.put(RenderContext.Companion.getSPECIES(), (Object)this.poserId);
        this.context.put(RenderContext.Companion.getPOSABLE_STATE(), (Object)state);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(((Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()));
        poseStack.translate(-0.5, 0.0, -0.5);
        poseStack.translate(1.0, 0.0, 0.0);
        model.applyAnimations(null, (PosableState)state, 0.0f, 0.0f, state.getAnimationSeconds() * 20.0f, 0.0f, 0.0f);
        model.render(this.context, poseStack, vertexConsumer, packedLight, overlay, -1);
        model.withLayerContext(multiBufferSource, (PosableState)state, VaryingModelRepository.INSTANCE.getLayers(this.poserId, (PosableState)state), () -> {
            model.render(this.context, poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            return Unit.INSTANCE;
        });
        model.setDefault();
        poseStack.popPose();
    }
}

