/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block.block_entity;

import com.github.yajatkaul.mega_showdown.block.MegaShowdownBlockEntities;
import com.github.yajatkaul.mega_showdown.block.custom.ReassemblyUnitBlock;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ReassemblyUnitBlockEntity
extends BlockEntity {
    private int cookTime = 0;
    private int maxCookTime = -1;
    private ReassembleStage stage = ReassembleStage.IDLE;

    public ReassemblyUnitBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)MegaShowdownBlockEntities.REASSEMBLY_UNIT_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ReassemblyUnitBlockEntity be) {
        if (level.isClientSide) {
            return;
        }
        if (be.isCooking()) {
            ++be.cookTime;
        }
        if (be.cookTime >= be.maxCookTime && be.maxCookTime > 0) {
            ReassembleStage finishedStage;
            be.stage = finishedStage = (switch (be.stage.ordinal()) {
                case 1 -> ReassembleStage.FINISHED_10;
                case 2 -> ReassembleStage.FINISHED_50;
                case 3 -> ReassembleStage.FINISHED_100;
                default -> ReassembleStage.IDLE;
            });
            be.maxCookTime = -1;
            be.cookTime = 0;
            level.setBlock(pos, (BlockState)state.setValue(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)finishedStage)), 3);
            BlockState upperState = level.getBlockState(pos.above());
            if (upperState.getBlock() instanceof ReassemblyUnitBlock) {
                level.setBlock(pos.above(), (BlockState)upperState.setValue(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)finishedStage)), 3);
            }
            ReassemblyUnitBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void startProcess(ReassembleStage stage, int durationTicks) {
        this.stage = stage;
        this.cookTime = 0;
        this.maxCookTime = durationTicks;
        if (this.level != null) {
            BlockPos lowerPos = this.worldPosition;
            BlockPos upperPos = lowerPos.above();
            BlockState lowerState = this.level.getBlockState(lowerPos);
            this.level.setBlock(lowerPos, (BlockState)lowerState.setValue(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage)), 3);
            BlockState upperState = this.level.getBlockState(upperPos);
            if (upperState.getBlock() instanceof ReassemblyUnitBlock) {
                this.level.setBlock(upperPos, (BlockState)upperState.setValue(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage)), 3);
            }
        }
    }

    public boolean isIdle() {
        return this.stage == ReassembleStage.IDLE;
    }

    public boolean isCooking() {
        return this.stage == ReassembleStage.COOKING_10 || this.stage == ReassembleStage.COOKING_50 || this.stage == ReassembleStage.COOKING_100;
    }

    public boolean isFinished() {
        return this.stage == ReassembleStage.FINISHED_10 || this.stage == ReassembleStage.FINISHED_50 || this.stage == ReassembleStage.FINISHED_100;
    }

    public ReassembleStage getStage() {
        return this.stage;
    }

    public void setStage(ReassembleStage stage) {
        this.stage = stage;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            BlockState upperState;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos lowerPos = this.getBlockPos();
            BlockPos upperPos = lowerPos.above();
            BlockState lowerState = serverLevel.getBlockState(lowerPos);
            if (lowerState.getBlock() instanceof ReassemblyUnitBlock) {
                BlockState newLowerState = (BlockState)lowerState.setValue(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage));
                serverLevel.setBlock(lowerPos, newLowerState, 3);
            }
            if ((upperState = serverLevel.getBlockState(upperPos)).getBlock() instanceof ReassemblyUnitBlock) {
                BlockState newUpperState = (BlockState)upperState.setValue(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage));
                serverLevel.setBlock(upperPos, newUpperState, 3);
            }
            ReassemblyUnitBlockEntity.setChanged((Level)serverLevel, (BlockPos)lowerPos, (BlockState)this.getBlockState());
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("CookTime", this.cookTime);
        tag.putInt("MaxCookTime", this.maxCookTime);
        tag.putString("Stage", this.stage.name());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.cookTime = tag.getInt("CookTime");
        this.maxCookTime = tag.getInt("MaxCookTime");
        this.stage = ReassembleStage.valueOf(tag.getString("Stage"));
    }

    public static enum ReassembleStage implements StringRepresentable
    {
        IDLE,
        COOKING_10,
        COOKING_50,
        COOKING_100,
        FINISHED_10,
        FINISHED_50,
        FINISHED_100;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

