/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block;

import com.github.yajatkaul.mega_showdown.block.custom.CustomHitBoxBlock;
import com.github.yajatkaul.mega_showdown.block.custom.DormantCrystal;
import com.github.yajatkaul.mega_showdown.block.custom.HorizontalDirectionalBlock;
import com.github.yajatkaul.mega_showdown.block.custom.MaxMushroomBlock;
import com.github.yajatkaul.mega_showdown.block.custom.MegaStoneStand;
import com.github.yajatkaul.mega_showdown.block.custom.ParticleBlock;
import com.github.yajatkaul.mega_showdown.block.custom.PedestalBlock;
import com.github.yajatkaul.mega_showdown.block.custom.PokemonSelectingBlock;
import com.github.yajatkaul.mega_showdown.block.custom.ReassemblyUnitBlock;
import com.github.yajatkaul.mega_showdown.block.custom.RotomUnitBlock;
import com.github.yajatkaul.mega_showdown.creative.MegaShowdownTabs;
import com.github.yajatkaul.mega_showdown.item.MegaShowdownItems;
import com.github.yajatkaul.mega_showdown.item.custom.dynamax.MaxMushroom;
import com.github.yajatkaul.mega_showdown.item.custom.form_change.DeoxysMeteoridItem;
import com.github.yajatkaul.mega_showdown.item.custom.form_change.Gracedia;
import com.github.yajatkaul.mega_showdown.item.custom.form_change.RotomUnitItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.DeferredSupplier;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.joml.Vector3f;

public class MegaShowdownBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"mega_showdown", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> POWER_SPOT = MegaShowdownBlocks.registerBlockWithToolTip("power_spot", () -> new CustomHitBoxBlock(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_RED).lightLevel(state -> 15).requiresCorrectToolForDrops().sound(SoundType.STONE), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0)), MegaShowdownTabs.DYNAMAX_TAB);
    public static final RegistrySupplier<Block> MAX_MUSHROOM = MegaShowdownBlocks.registerBlockWithBlockItem("max_mushroom", () -> new MaxMushroomBlock(BlockBehaviour.Properties.of().noCollission().sound(SoundType.FLOWERING_AZALEA)), block -> new MaxMushroom((Block)block.get(), new Item.Properties().arch$tab(MegaShowdownTabs.DYNAMAX_TAB)));
    public static final RegistrySupplier<Block> GRACIDEA_FLOWER = MegaShowdownBlocks.registerBlockWithBlockItem("gracidea_flower", () -> new FlowerBlock(MobEffects.HEAL, 8.0f, BlockBehaviour.Properties.of().noCollission().noOcclusion().lightLevel(state -> 15).instabreak().sound(SoundType.GRASS)), block -> new Gracedia((Block)block.get(), new Item.Properties().arch$tab(MegaShowdownTabs.FORM_TAB)));
    public static final RegistrySupplier<Block> POTTED_GRACIDEA = MegaShowdownBlocks.registerFlowerPlotBlock("potted_gracidea", GRACIDEA_FLOWER);
    public static final RegistrySupplier<Block> REASSEMBLY_UNIT = MegaShowdownBlocks.registerBlockWithToolTip("reassembly_unit", () -> new ReassemblyUnitBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.METAL).strength(3.0f).pushReaction(PushReaction.IGNORE)), MegaShowdownTabs.FORM_TAB);
    public static final RegistrySupplier<Block> PEDESTAL = MegaShowdownBlocks.registerBlockWithToolTip("pedestal", () -> new PedestalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.STONE).strength(2.0f)), MegaShowdownTabs.KEY_TAB);
    public static final RegistrySupplier<Block> MEGA_METEOROID_BLOCK = MegaShowdownBlocks.registerMeteoroidBlock("mega_meteorid_block");
    public static final RegistrySupplier<Block> MEGA_METEOROID_RADIATED_BLOCK = MegaShowdownBlocks.registerMeteoroidBlock("mega_meteorid_radiated_block");
    public static final RegistrySupplier<Block> MEGA_METEOROID_BRICK = MegaShowdownBlocks.registerMeteoroidBlock("mega_meteorid_brick");
    public static final RegistrySupplier<Block> CHISELED_MEGA_METEOROID_BLOCK = MegaShowdownBlocks.registerMeteoroidBlock("chiseled_mega_meteorid_block");
    public static final RegistrySupplier<Block> CHISELED_MEGA_METEOROID_BRICK = MegaShowdownBlocks.registerMeteoroidBlock("chiseled_mega_meteorid_brick");
    public static final RegistrySupplier<Block> POLISHED_MEGA_METEOROID_BLOCK = MegaShowdownBlocks.registerMeteoroidBlock("polished_mega_meteorid_block");
    public static final RegistrySupplier<Block> KEYSTONE_ORE = MegaShowdownBlocks.registerBlock("keystone_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)6, (int)9), BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.AMETHYST)), MegaShowdownTabs.MEGA_TAB);
    public static final RegistrySupplier<Block> KEYSTONE_BLOCK = MegaShowdownBlocks.registerBlock("keystone_block", () -> new HorizontalDirectionalBlock(BlockBehaviour.Properties.of().mapColor(DyeColor.PINK)), MegaShowdownTabs.MEGA_TAB);
    public static final RegistrySupplier<Block> MEGA_METEORID_WATER_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_water_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_DAWN_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_dawn_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_DUSK_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_dusk_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_FIRE_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_fire_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_ICE_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_ice_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_LEAF_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_leaf_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_MOON_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_moon_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_SHINY_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_shiny_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_SUN_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_sun_ore");
    public static final RegistrySupplier<Block> MEGA_METEORID_THUNDER_ORE = MegaShowdownBlocks.registerMeteoroidOre("mega_meteorid_thunder_ore");
    public static final RegistrySupplier<Block> MEGA_STONE_CRYSTAL = MegaShowdownBlocks.registerBlock("mega_stone_crystal", () -> new MegaStoneStand(BlockBehaviour.Properties.of().strength(1.5f).sound(SoundType.MEDIUM_AMETHYST_BUD).noOcclusion().requiresCorrectToolForDrops().pushReaction(PushReaction.IGNORE).lightLevel(state -> 15)), MegaShowdownTabs.MEGA_TAB);
    public static final RegistrySupplier<Block> WISHING_STAR_CRYSTAL = MegaShowdownBlocks.registerBlock("wishing_star_crystal", () -> new ParticleBlock(4.0f, 3.0f, BlockBehaviour.Properties.of().strength(1.5f).sound(SoundType.MEDIUM_AMETHYST_BUD).noOcclusion().requiresCorrectToolForDrops().pushReaction(PushReaction.IGNORE).lightLevel(state -> 15), true, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), (ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 0.5f)), MegaShowdownTabs.DYNAMAX_TAB);
    public static final RegistrySupplier<Block> DORMANT_CRYSTAL = MegaShowdownBlocks.registerBlockWithToolTip("dormant_crystal", () -> new DormantCrystal(4.0f, 3.0f, BlockBehaviour.Properties.of(), false), MegaShowdownTabs.TERA_TAB);
    public static final RegistrySupplier<Block> DEOXYS_METEORITE = MegaShowdownBlocks.registerDeoxysMeteorite("deoxys_meteorite");
    public static final RegistrySupplier<Block> ROTOM_WASHING_MACHINE = MegaShowdownBlocks.registerRotomBlock("rotom_washing_machine", "wash");
    public static final RegistrySupplier<Block> ROTOM_FAN = MegaShowdownBlocks.registerRotomBlock("rotom_fan", "fan");
    public static final RegistrySupplier<Block> ROTOM_MOW = MegaShowdownBlocks.registerRotomBlock("rotom_mow", "mow");
    public static final RegistrySupplier<Block> ROTOM_FRIDGE = MegaShowdownBlocks.registerRotomBlock("rotom_fridge", "frost");
    public static final RegistrySupplier<Block> ROTOM_OVEN = MegaShowdownBlocks.registerRotomBlock("rotom_oven", "heat");

    private static RegistrySupplier<Block> registerRotomBlock(String name, String form) {
        return MegaShowdownBlocks.registerBlockWithBlockItem(name, () -> new RotomUnitBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).mapColor(DyeColor.ORANGE).sound(SoundType.METAL), form), block -> new RotomUnitItem((Block)block.get(), new Item.Properties().arch$tab(MegaShowdownTabs.FORM_TAB), form));
    }

    private static RegistrySupplier<Block> registerDeoxysMeteorite(String name) {
        RegistrySupplier blockSupplier = BLOCKS.register(name, () -> new PokemonSelectingBlock(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE), ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)name), false));
        MegaShowdownItems.ITEMS.register(name, () -> new DeoxysMeteoridItem((Block)blockSupplier.get(), new Item.Properties().arch$tab(MegaShowdownTabs.FORM_TAB)));
        return blockSupplier;
    }

    private static RegistrySupplier<Block> registerFlowerPlotBlock(String name, Supplier<Block> block) {
        return BLOCKS.register(name, () -> new FlowerPotBlock((Block)block.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM).noOcclusion().instabreak()));
    }

    private static RegistrySupplier<Block> registerMeteoroidOre(String name) {
        RegistrySupplier blockSupplier = BLOCKS.register(name, () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)6), BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
        MegaShowdownItems.ITEMS.register(name, () -> new BlockItem((Block)blockSupplier.get(), new Item.Properties().arch$tab(MegaShowdownTabs.MEGA_TAB)));
        return blockSupplier;
    }

    private static RegistrySupplier<Block> registerMeteoroidBlock(String name) {
        RegistrySupplier blockSupplier = BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
        MegaShowdownItems.ITEMS.register(name, () -> new BlockItem((Block)blockSupplier.get(), new Item.Properties().arch$tab(MegaShowdownTabs.MEGA_TAB)));
        return blockSupplier;
    }

    private static RegistrySupplier<Block> registerBlockWithBlockItem(String name, Supplier<Block> block, Function<RegistrySupplier<Block>, Item> itemFactory) {
        RegistrySupplier blockSupplier = BLOCKS.register(name, block);
        MegaShowdownItems.ITEMS.register(name, () -> (Item)itemFactory.apply(blockSupplier));
        return blockSupplier;
    }

    private static RegistrySupplier<Block> registerBlock(String name, Supplier<Block> block, DeferredSupplier<CreativeModeTab> tab) {
        RegistrySupplier blockSupplier = BLOCKS.register(name, block);
        MegaShowdownItems.ITEMS.register(name, () -> new BlockItem((Block)blockSupplier.get(), new Item.Properties().arch$tab(tab)));
        return blockSupplier;
    }

    private static RegistrySupplier<Block> registerBlockWithToolTip(final String name, Supplier<Block> block, DeferredSupplier<CreativeModeTab> tab) {
        RegistrySupplier blockSupplier = BLOCKS.register(name, block);
        MegaShowdownItems.ITEMS.register(name, () -> new BlockItem((Block)blockSupplier.get(), new Item.Properties().arch$tab(tab)){

            public void appendHoverText(ItemStack arg, Item.TooltipContext arg2, List<Component> list, TooltipFlag arg3) {
                list.add((Component)Component.translatable((String)("tooltip.mega_showdown." + name + ".tooltip")));
                super.appendHoverText(arg, arg2, list, arg3);
            }
        });
        return blockSupplier;
    }

    public static void register() {
        BLOCKS.register();
    }
}

