/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.battle.effect;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormParticlePacket;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractFieldHandler {
    protected static void sendFieldEffect(ResourceLocation snowstormParticle, PokemonBattle battle) {
        Vec3 centre = AbstractFieldHandler.getBattleCentre(battle);
        Level level = AbstractFieldHandler.getBattleWorld(battle);
        if (level == null) {
            return;
        }
        SpawnSnowstormParticlePacket packet = new SpawnSnowstormParticlePacket(snowstormParticle, centre);
        battle.sendUpdate((NetworkPacket)packet);
    }

    protected static Vec3 getBattleCentre(PokemonBattle battle) {
        ArrayList<Vec3> pokemonPositions = new ArrayList<Vec3>();
        for (ActiveBattlePokemon pokemon : battle.getActivePokemon()) {
            if (pokemon.getPosition() == null) continue;
            pokemonPositions.add((Vec3)pokemon.getPosition().getSecond());
        }
        return pokemonPositions.stream().reduce(Vec3.ZERO, Vec3::add).scale(1.0 / (double)pokemonPositions.size());
    }

    protected static Level getBattleWorld(PokemonBattle battle) {
        for (BattleActor actor : battle.getActors()) {
            EntityBackedBattleActor entityActor;
            if (!(actor instanceof EntityBackedBattleActor) || (entityActor = (EntityBackedBattleActor)actor).getEntity() == null) continue;
            return entityActor.getEntity().level();
        }
        return null;
    }
}

