/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemCapabilityDelegator;

public class VanillaEntityItemItemHandler
extends VanillaEntityItemCapabilityDelegator<IItemHandler>
implements IItemHandler {
    public VanillaEntityItemItemHandler(ItemEntity entity) {
        super(entity);
    }

    @Override
    protected ItemCapability<IItemHandler, Void> getCapabilityType() {
        return Capabilities.ItemHandler.ITEM;
    }

    public int getSlots() {
        return this.getCapability().map(IItemHandler::getSlots).orElse(0);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getCapability().map(itemHandler -> itemHandler.getStackInSlot(slot)).orElse(ItemStack.EMPTY);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.getCapability().map(itemHandler -> {
            ItemStack innerStack = this.getItemStack();
            ItemStack ret = itemHandler.insertItem(slot, stack, simulate);
            if (stack.getCount() != ret.getCount() && !simulate) {
                this.updateItemStack(innerStack);
            }
            return ret;
        }).orElse(ItemStack.EMPTY);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getCapability().map(itemHandler -> {
            ItemStack innerStack = this.getItemStack();
            ItemStack ret = itemHandler.extractItem(slot, amount, simulate);
            if (!ret.isEmpty() && !simulate) {
                this.updateItemStack(innerStack);
            }
            return ret;
        }).orElse(ItemStack.EMPTY);
    }

    public int getSlotLimit(int slot) {
        return this.getCapability().map(itemHandler -> itemHandler.getSlotLimit(slot)).orElse(0);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.getCapability().map(itemHandler -> itemHandler.isItemValid(slot, stack)).orElse(false);
    }
}

