/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient;

import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;

public class IngredientSerializerItemStack
implements IIngredientSerializer<ItemStack, Integer> {
    @Override
    public Tag serializeInstance(HolderLookup.Provider lookupProvider, ItemStack instance) {
        int count = instance.getCount();
        if (instance.getCount() > 99) {
            instance = instance.copy();
            instance.setCount(99);
        }
        Tag tag = (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)instance).getOrThrow(JsonParseException::new);
        if (count > 99) {
            ((CompoundTag)tag).putInt("ExtendedCount", count);
        }
        return tag;
    }

    @Override
    public ItemStack deserializeInstance(HolderLookup.Provider lookupProvider, Tag tag) throws IllegalArgumentException {
        ItemStack itemStack = (ItemStack)ItemStack.OPTIONAL_CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow(JsonParseException::new);
        if (!(tag instanceof CompoundTag)) {
            throw new IllegalArgumentException("This deserializer only accepts NBTTagCompound");
        }
        CompoundTag stackTag = (CompoundTag)tag;
        if (stackTag.contains("ExtendedCount", 3)) {
            itemStack.setCount(stackTag.getInt("ExtendedCount"));
        }
        return itemStack;
    }

    @Override
    public Tag serializeCondition(Integer matchCondition) {
        return IntTag.valueOf((int)matchCondition);
    }

    @Override
    public Integer deserializeCondition(Tag tag) throws IllegalArgumentException {
        if (!(tag instanceof IntTag)) {
            throw new IllegalArgumentException("This deserializer only accepts NBTTagInt");
        }
        return ((IntTag)tag).getAsInt();
    }
}

